module hbms10_t1t (
		input  wire         pll_ref_clk,                 //         pll_ref_clk.clk
		input  wire         ext_core_clk,                //        ext_core_clk.clk
		input  wire         ext_core_clk_locked,         // ext_core_clk_locked.export
		input  wire         wmcrst_n_in,                 //         wmcrst_n_in.reset_n
		input  wire         hbm_only_reset_in,           //   hbm_only_reset_in.reset
		output wire         local_cal_success,           //              status.local_cal_success
		output wire         local_cal_fail,              //                    .local_cal_fail
		output wire [2:0]   cal_lat,                     //             cal_lat.cal_lat
		output wire         ck_t_0,                      //               mem_0.ck_t
		output wire         ck_c_0,                      //                    .ck_c
		output wire         cke_0,                       //                    .cke
		output wire [7:0]   c_0,                         //                    .c
		output wire [5:0]   r_0,                         //                    .r
		inout  wire [127:0] dq_0,                        //                    .dq
		inout  wire [15:0]  dm_0,                        //                    .dm
		inout  wire [15:0]  dbi_0,                       //                    .dbi
		inout  wire [3:0]   par_0,                       //                    .par
		inout  wire [3:0]   derr_0,                      //                    .derr
		input  wire [3:0]   rdqs_t_0,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_0,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_0,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_0,                    //                    .wdqs_c
		inout  wire [7:0]   rd_0,                        //                    .rd
		output wire         rr_0,                        //                    .rr
		output wire         rc_0,                        //                    .rc
		input  wire         aerr_0,                      //                    .aerr
		output wire         ck_t_1,                      //               mem_1.ck_t
		output wire         ck_c_1,                      //                    .ck_c
		output wire         cke_1,                       //                    .cke
		output wire [7:0]   c_1,                         //                    .c
		output wire [5:0]   r_1,                         //                    .r
		inout  wire [127:0] dq_1,                        //                    .dq
		inout  wire [15:0]  dm_1,                        //                    .dm
		inout  wire [15:0]  dbi_1,                       //                    .dbi
		inout  wire [3:0]   par_1,                       //                    .par
		inout  wire [3:0]   derr_1,                      //                    .derr
		input  wire [3:0]   rdqs_t_1,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_1,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_1,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_1,                    //                    .wdqs_c
		inout  wire [7:0]   rd_1,                        //                    .rd
		output wire         rr_1,                        //                    .rr
		output wire         rc_1,                        //                    .rc
		input  wire         aerr_1,                      //                    .aerr
		output wire         ck_t_2,                      //               mem_2.ck_t
		output wire         ck_c_2,                      //                    .ck_c
		output wire         cke_2,                       //                    .cke
		output wire [7:0]   c_2,                         //                    .c
		output wire [5:0]   r_2,                         //                    .r
		inout  wire [127:0] dq_2,                        //                    .dq
		inout  wire [15:0]  dm_2,                        //                    .dm
		inout  wire [15:0]  dbi_2,                       //                    .dbi
		inout  wire [3:0]   par_2,                       //                    .par
		inout  wire [3:0]   derr_2,                      //                    .derr
		input  wire [3:0]   rdqs_t_2,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_2,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_2,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_2,                    //                    .wdqs_c
		inout  wire [7:0]   rd_2,                        //                    .rd
		output wire         rr_2,                        //                    .rr
		output wire         rc_2,                        //                    .rc
		input  wire         aerr_2,                      //                    .aerr
		output wire         ck_t_3,                      //               mem_3.ck_t
		output wire         ck_c_3,                      //                    .ck_c
		output wire         cke_3,                       //                    .cke
		output wire [7:0]   c_3,                         //                    .c
		output wire [5:0]   r_3,                         //                    .r
		inout  wire [127:0] dq_3,                        //                    .dq
		inout  wire [15:0]  dm_3,                        //                    .dm
		inout  wire [15:0]  dbi_3,                       //                    .dbi
		inout  wire [3:0]   par_3,                       //                    .par
		inout  wire [3:0]   derr_3,                      //                    .derr
		input  wire [3:0]   rdqs_t_3,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_3,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_3,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_3,                    //                    .wdqs_c
		inout  wire [7:0]   rd_3,                        //                    .rd
		output wire         rr_3,                        //                    .rr
		output wire         rc_3,                        //                    .rc
		input  wire         aerr_3,                      //                    .aerr
		output wire         ck_t_4,                      //               mem_4.ck_t
		output wire         ck_c_4,                      //                    .ck_c
		output wire         cke_4,                       //                    .cke
		output wire [7:0]   c_4,                         //                    .c
		output wire [5:0]   r_4,                         //                    .r
		inout  wire [127:0] dq_4,                        //                    .dq
		inout  wire [15:0]  dm_4,                        //                    .dm
		inout  wire [15:0]  dbi_4,                       //                    .dbi
		inout  wire [3:0]   par_4,                       //                    .par
		inout  wire [3:0]   derr_4,                      //                    .derr
		input  wire [3:0]   rdqs_t_4,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_4,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_4,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_4,                    //                    .wdqs_c
		inout  wire [7:0]   rd_4,                        //                    .rd
		output wire         rr_4,                        //                    .rr
		output wire         rc_4,                        //                    .rc
		input  wire         aerr_4,                      //                    .aerr
		output wire         ck_t_5,                      //               mem_5.ck_t
		output wire         ck_c_5,                      //                    .ck_c
		output wire         cke_5,                       //                    .cke
		output wire [7:0]   c_5,                         //                    .c
		output wire [5:0]   r_5,                         //                    .r
		inout  wire [127:0] dq_5,                        //                    .dq
		inout  wire [15:0]  dm_5,                        //                    .dm
		inout  wire [15:0]  dbi_5,                       //                    .dbi
		inout  wire [3:0]   par_5,                       //                    .par
		inout  wire [3:0]   derr_5,                      //                    .derr
		input  wire [3:0]   rdqs_t_5,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_5,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_5,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_5,                    //                    .wdqs_c
		inout  wire [7:0]   rd_5,                        //                    .rd
		output wire         rr_5,                        //                    .rr
		output wire         rc_5,                        //                    .rc
		input  wire         aerr_5,                      //                    .aerr
		output wire         ck_t_6,                      //               mem_6.ck_t
		output wire         ck_c_6,                      //                    .ck_c
		output wire         cke_6,                       //                    .cke
		output wire [7:0]   c_6,                         //                    .c
		output wire [5:0]   r_6,                         //                    .r
		inout  wire [127:0] dq_6,                        //                    .dq
		inout  wire [15:0]  dm_6,                        //                    .dm
		inout  wire [15:0]  dbi_6,                       //                    .dbi
		inout  wire [3:0]   par_6,                       //                    .par
		inout  wire [3:0]   derr_6,                      //                    .derr
		input  wire [3:0]   rdqs_t_6,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_6,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_6,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_6,                    //                    .wdqs_c
		inout  wire [7:0]   rd_6,                        //                    .rd
		output wire         rr_6,                        //                    .rr
		output wire         rc_6,                        //                    .rc
		input  wire         aerr_6,                      //                    .aerr
		output wire         ck_t_7,                      //               mem_7.ck_t
		output wire         ck_c_7,                      //                    .ck_c
		output wire         cke_7,                       //                    .cke
		output wire [7:0]   c_7,                         //                    .c
		output wire [5:0]   r_7,                         //                    .r
		inout  wire [127:0] dq_7,                        //                    .dq
		inout  wire [15:0]  dm_7,                        //                    .dm
		inout  wire [15:0]  dbi_7,                       //                    .dbi
		inout  wire [3:0]   par_7,                       //                    .par
		inout  wire [3:0]   derr_7,                      //                    .derr
		input  wire [3:0]   rdqs_t_7,                    //                    .rdqs_t
		input  wire [3:0]   rdqs_c_7,                    //                    .rdqs_c
		output wire [3:0]   wdqs_t_7,                    //                    .wdqs_t
		output wire [3:0]   wdqs_c_7,                    //                    .wdqs_c
		inout  wire [7:0]   rd_7,                        //                    .rd
		output wire         rr_7,                        //                    .rr
		output wire         rc_7,                        //                    .rc
		input  wire         aerr_7,                      //                    .aerr
		input  wire         cattrip,                     //          m2u_bridge.cattrip
		input  wire [2:0]   temp,                        //                    .temp
		input  wire [7:0]   wso,                         //                    .wso
		output wire         reset_n,                     //                    .reset_n
		output wire         wrst_n,                      //                    .wrst_n
		output wire         wrck,                        //                    .wrck
		output wire         shiftwr,                     //                    .shiftwr
		output wire         capturewr,                   //                    .capturewr
		output wire         updatewr,                    //                    .updatewr
		output wire         selectwir,                   //                    .selectwir
		output wire         wsi,                         //                    .wsi
		output wire         wmc_clk_0_clk,               //           wmc_clk_0.clk
		output wire         wmc_clk_1_clk,               //           wmc_clk_1.clk
		output wire         phy_clk_0_clk,               //           phy_clk_0.clk
		output wire         phy_clk_1_clk,               //           phy_clk_1.clk
		output wire         wmcrst_n_0_reset_n,          //          wmcrst_n_0.reset_n
		output wire         wmcrst_n_1_reset_n,          //          wmcrst_n_1.reset_n
		input  wire [8:0]   axi_0_1_awid,                //             axi_0_1.awid
		input  wire [27:0]  axi_0_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_0_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_0_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_0_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_0_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_0_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_0_1_awuser,              //                    .awuser
		input  wire         axi_0_1_awvalid,             //                    .awvalid
		output wire         axi_0_1_awready,             //                    .awready
		input  wire [255:0] axi_0_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_0_1_wstrb,               //                    .wstrb
		input  wire         axi_0_1_wlast,               //                    .wlast
		input  wire         axi_0_1_wvalid,              //                    .wvalid
		output wire         axi_0_1_wready,              //                    .wready
		output wire [8:0]   axi_0_1_bid,                 //                    .bid
		output wire [1:0]   axi_0_1_bresp,               //                    .bresp
		output wire         axi_0_1_bvalid,              //                    .bvalid
		input  wire         axi_0_1_bready,              //                    .bready
		input  wire [8:0]   axi_0_1_arid,                //                    .arid
		input  wire [27:0]  axi_0_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_0_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_0_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_0_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_0_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_0_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_0_1_aruser,              //                    .aruser
		input  wire         axi_0_1_arvalid,             //                    .arvalid
		output wire         axi_0_1_arready,             //                    .arready
		output wire [8:0]   axi_0_1_rid,                 //                    .rid
		output wire [255:0] axi_0_1_rdata,               //                    .rdata
		output wire [1:0]   axi_0_1_rresp,               //                    .rresp
		output wire         axi_0_1_rlast,               //                    .rlast
		output wire         axi_0_1_rvalid,              //                    .rvalid
		input  wire         axi_0_1_rready,              //                    .rready
		input  wire [8:0]   axi_0_0_awid,                //             axi_0_0.awid
		input  wire [27:0]  axi_0_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_0_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_0_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_0_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_0_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_0_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_0_0_awuser,              //                    .awuser
		input  wire         axi_0_0_awvalid,             //                    .awvalid
		output wire         axi_0_0_awready,             //                    .awready
		input  wire [255:0] axi_0_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_0_0_wstrb,               //                    .wstrb
		input  wire         axi_0_0_wlast,               //                    .wlast
		input  wire         axi_0_0_wvalid,              //                    .wvalid
		output wire         axi_0_0_wready,              //                    .wready
		output wire [8:0]   axi_0_0_bid,                 //                    .bid
		output wire [1:0]   axi_0_0_bresp,               //                    .bresp
		output wire         axi_0_0_bvalid,              //                    .bvalid
		input  wire         axi_0_0_bready,              //                    .bready
		input  wire [8:0]   axi_0_0_arid,                //                    .arid
		input  wire [27:0]  axi_0_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_0_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_0_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_0_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_0_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_0_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_0_0_aruser,              //                    .aruser
		input  wire         axi_0_0_arvalid,             //                    .arvalid
		output wire         axi_0_0_arready,             //                    .arready
		output wire [8:0]   axi_0_0_rid,                 //                    .rid
		output wire [255:0] axi_0_0_rdata,               //                    .rdata
		output wire [1:0]   axi_0_0_rresp,               //                    .rresp
		output wire         axi_0_0_rlast,               //                    .rlast
		output wire         axi_0_0_rvalid,              //                    .rvalid
		input  wire         axi_0_0_rready,              //                    .rready
		input  wire [8:0]   axi_1_1_awid,                //             axi_1_1.awid
		input  wire [27:0]  axi_1_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_1_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_1_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_1_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_1_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_1_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_1_1_awuser,              //                    .awuser
		input  wire         axi_1_1_awvalid,             //                    .awvalid
		output wire         axi_1_1_awready,             //                    .awready
		input  wire [255:0] axi_1_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_1_1_wstrb,               //                    .wstrb
		input  wire         axi_1_1_wlast,               //                    .wlast
		input  wire         axi_1_1_wvalid,              //                    .wvalid
		output wire         axi_1_1_wready,              //                    .wready
		output wire [8:0]   axi_1_1_bid,                 //                    .bid
		output wire [1:0]   axi_1_1_bresp,               //                    .bresp
		output wire         axi_1_1_bvalid,              //                    .bvalid
		input  wire         axi_1_1_bready,              //                    .bready
		input  wire [8:0]   axi_1_1_arid,                //                    .arid
		input  wire [27:0]  axi_1_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_1_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_1_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_1_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_1_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_1_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_1_1_aruser,              //                    .aruser
		input  wire         axi_1_1_arvalid,             //                    .arvalid
		output wire         axi_1_1_arready,             //                    .arready
		output wire [8:0]   axi_1_1_rid,                 //                    .rid
		output wire [255:0] axi_1_1_rdata,               //                    .rdata
		output wire [1:0]   axi_1_1_rresp,               //                    .rresp
		output wire         axi_1_1_rlast,               //                    .rlast
		output wire         axi_1_1_rvalid,              //                    .rvalid
		input  wire         axi_1_1_rready,              //                    .rready
		input  wire [8:0]   axi_1_0_awid,                //             axi_1_0.awid
		input  wire [27:0]  axi_1_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_1_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_1_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_1_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_1_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_1_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_1_0_awuser,              //                    .awuser
		input  wire         axi_1_0_awvalid,             //                    .awvalid
		output wire         axi_1_0_awready,             //                    .awready
		input  wire [255:0] axi_1_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_1_0_wstrb,               //                    .wstrb
		input  wire         axi_1_0_wlast,               //                    .wlast
		input  wire         axi_1_0_wvalid,              //                    .wvalid
		output wire         axi_1_0_wready,              //                    .wready
		output wire [8:0]   axi_1_0_bid,                 //                    .bid
		output wire [1:0]   axi_1_0_bresp,               //                    .bresp
		output wire         axi_1_0_bvalid,              //                    .bvalid
		input  wire         axi_1_0_bready,              //                    .bready
		input  wire [8:0]   axi_1_0_arid,                //                    .arid
		input  wire [27:0]  axi_1_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_1_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_1_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_1_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_1_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_1_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_1_0_aruser,              //                    .aruser
		input  wire         axi_1_0_arvalid,             //                    .arvalid
		output wire         axi_1_0_arready,             //                    .arready
		output wire [8:0]   axi_1_0_rid,                 //                    .rid
		output wire [255:0] axi_1_0_rdata,               //                    .rdata
		output wire [1:0]   axi_1_0_rresp,               //                    .rresp
		output wire         axi_1_0_rlast,               //                    .rlast
		output wire         axi_1_0_rvalid,              //                    .rvalid
		input  wire         axi_1_0_rready,              //                    .rready
		output wire         axi_extra_0_1_ruser_err_dbe, //       axi_extra_0_1.ruser_err_dbe
		output wire [31:0]  axi_extra_0_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_0_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_0_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_0_0_ruser_err_dbe, //       axi_extra_0_0.ruser_err_dbe
		output wire [31:0]  axi_extra_0_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_0_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_0_0_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_1_1_ruser_err_dbe, //       axi_extra_1_1.ruser_err_dbe
		output wire [31:0]  axi_extra_1_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_1_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_1_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_1_0_ruser_err_dbe, //       axi_extra_1_0.ruser_err_dbe
		output wire [31:0]  axi_extra_1_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_1_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_1_0_wuser_strb,    //                    .wuser_strb
		input  wire [15:0]  apb_0_ur_paddr,              //               apb_0.ur_paddr
		input  wire         apb_0_ur_psel,               //                    .ur_psel
		input  wire         apb_0_ur_penable,            //                    .ur_penable
		input  wire         apb_0_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_0_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_0_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_0_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_0_ur_prdata,             //                    .ur_prdata
		input  wire [15:0]  apb_1_ur_paddr,              //               apb_1.ur_paddr
		input  wire         apb_1_ur_psel,               //                    .ur_psel
		input  wire         apb_1_ur_penable,            //                    .ur_penable
		input  wire         apb_1_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_1_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_1_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_1_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_1_ur_prdata,             //                    .ur_prdata
		output wire         wmc_clk_2_clk,               //           wmc_clk_2.clk
		output wire         wmc_clk_3_clk,               //           wmc_clk_3.clk
		output wire         phy_clk_2_clk,               //           phy_clk_2.clk
		output wire         phy_clk_3_clk,               //           phy_clk_3.clk
		output wire         wmcrst_n_2_reset_n,          //          wmcrst_n_2.reset_n
		output wire         wmcrst_n_3_reset_n,          //          wmcrst_n_3.reset_n
		input  wire [8:0]   axi_2_1_awid,                //             axi_2_1.awid
		input  wire [27:0]  axi_2_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_2_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_2_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_2_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_2_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_2_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_2_1_awuser,              //                    .awuser
		input  wire         axi_2_1_awvalid,             //                    .awvalid
		output wire         axi_2_1_awready,             //                    .awready
		input  wire [255:0] axi_2_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_2_1_wstrb,               //                    .wstrb
		input  wire         axi_2_1_wlast,               //                    .wlast
		input  wire         axi_2_1_wvalid,              //                    .wvalid
		output wire         axi_2_1_wready,              //                    .wready
		output wire [8:0]   axi_2_1_bid,                 //                    .bid
		output wire [1:0]   axi_2_1_bresp,               //                    .bresp
		output wire         axi_2_1_bvalid,              //                    .bvalid
		input  wire         axi_2_1_bready,              //                    .bready
		input  wire [8:0]   axi_2_1_arid,                //                    .arid
		input  wire [27:0]  axi_2_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_2_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_2_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_2_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_2_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_2_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_2_1_aruser,              //                    .aruser
		input  wire         axi_2_1_arvalid,             //                    .arvalid
		output wire         axi_2_1_arready,             //                    .arready
		output wire [8:0]   axi_2_1_rid,                 //                    .rid
		output wire [255:0] axi_2_1_rdata,               //                    .rdata
		output wire [1:0]   axi_2_1_rresp,               //                    .rresp
		output wire         axi_2_1_rlast,               //                    .rlast
		output wire         axi_2_1_rvalid,              //                    .rvalid
		input  wire         axi_2_1_rready,              //                    .rready
		input  wire [8:0]   axi_2_0_awid,                //             axi_2_0.awid
		input  wire [27:0]  axi_2_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_2_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_2_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_2_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_2_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_2_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_2_0_awuser,              //                    .awuser
		input  wire         axi_2_0_awvalid,             //                    .awvalid
		output wire         axi_2_0_awready,             //                    .awready
		input  wire [255:0] axi_2_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_2_0_wstrb,               //                    .wstrb
		input  wire         axi_2_0_wlast,               //                    .wlast
		input  wire         axi_2_0_wvalid,              //                    .wvalid
		output wire         axi_2_0_wready,              //                    .wready
		output wire [8:0]   axi_2_0_bid,                 //                    .bid
		output wire [1:0]   axi_2_0_bresp,               //                    .bresp
		output wire         axi_2_0_bvalid,              //                    .bvalid
		input  wire         axi_2_0_bready,              //                    .bready
		input  wire [8:0]   axi_2_0_arid,                //                    .arid
		input  wire [27:0]  axi_2_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_2_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_2_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_2_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_2_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_2_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_2_0_aruser,              //                    .aruser
		input  wire         axi_2_0_arvalid,             //                    .arvalid
		output wire         axi_2_0_arready,             //                    .arready
		output wire [8:0]   axi_2_0_rid,                 //                    .rid
		output wire [255:0] axi_2_0_rdata,               //                    .rdata
		output wire [1:0]   axi_2_0_rresp,               //                    .rresp
		output wire         axi_2_0_rlast,               //                    .rlast
		output wire         axi_2_0_rvalid,              //                    .rvalid
		input  wire         axi_2_0_rready,              //                    .rready
		input  wire [8:0]   axi_3_1_awid,                //             axi_3_1.awid
		input  wire [27:0]  axi_3_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_3_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_3_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_3_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_3_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_3_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_3_1_awuser,              //                    .awuser
		input  wire         axi_3_1_awvalid,             //                    .awvalid
		output wire         axi_3_1_awready,             //                    .awready
		input  wire [255:0] axi_3_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_3_1_wstrb,               //                    .wstrb
		input  wire         axi_3_1_wlast,               //                    .wlast
		input  wire         axi_3_1_wvalid,              //                    .wvalid
		output wire         axi_3_1_wready,              //                    .wready
		output wire [8:0]   axi_3_1_bid,                 //                    .bid
		output wire [1:0]   axi_3_1_bresp,               //                    .bresp
		output wire         axi_3_1_bvalid,              //                    .bvalid
		input  wire         axi_3_1_bready,              //                    .bready
		input  wire [8:0]   axi_3_1_arid,                //                    .arid
		input  wire [27:0]  axi_3_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_3_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_3_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_3_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_3_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_3_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_3_1_aruser,              //                    .aruser
		input  wire         axi_3_1_arvalid,             //                    .arvalid
		output wire         axi_3_1_arready,             //                    .arready
		output wire [8:0]   axi_3_1_rid,                 //                    .rid
		output wire [255:0] axi_3_1_rdata,               //                    .rdata
		output wire [1:0]   axi_3_1_rresp,               //                    .rresp
		output wire         axi_3_1_rlast,               //                    .rlast
		output wire         axi_3_1_rvalid,              //                    .rvalid
		input  wire         axi_3_1_rready,              //                    .rready
		input  wire [8:0]   axi_3_0_awid,                //             axi_3_0.awid
		input  wire [27:0]  axi_3_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_3_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_3_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_3_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_3_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_3_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_3_0_awuser,              //                    .awuser
		input  wire         axi_3_0_awvalid,             //                    .awvalid
		output wire         axi_3_0_awready,             //                    .awready
		input  wire [255:0] axi_3_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_3_0_wstrb,               //                    .wstrb
		input  wire         axi_3_0_wlast,               //                    .wlast
		input  wire         axi_3_0_wvalid,              //                    .wvalid
		output wire         axi_3_0_wready,              //                    .wready
		output wire [8:0]   axi_3_0_bid,                 //                    .bid
		output wire [1:0]   axi_3_0_bresp,               //                    .bresp
		output wire         axi_3_0_bvalid,              //                    .bvalid
		input  wire         axi_3_0_bready,              //                    .bready
		input  wire [8:0]   axi_3_0_arid,                //                    .arid
		input  wire [27:0]  axi_3_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_3_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_3_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_3_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_3_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_3_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_3_0_aruser,              //                    .aruser
		input  wire         axi_3_0_arvalid,             //                    .arvalid
		output wire         axi_3_0_arready,             //                    .arready
		output wire [8:0]   axi_3_0_rid,                 //                    .rid
		output wire [255:0] axi_3_0_rdata,               //                    .rdata
		output wire [1:0]   axi_3_0_rresp,               //                    .rresp
		output wire         axi_3_0_rlast,               //                    .rlast
		output wire         axi_3_0_rvalid,              //                    .rvalid
		input  wire         axi_3_0_rready,              //                    .rready
		output wire         axi_extra_2_1_ruser_err_dbe, //       axi_extra_2_1.ruser_err_dbe
		output wire [31:0]  axi_extra_2_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_2_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_2_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_2_0_ruser_err_dbe, //       axi_extra_2_0.ruser_err_dbe
		output wire [31:0]  axi_extra_2_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_2_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_2_0_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_3_1_ruser_err_dbe, //       axi_extra_3_1.ruser_err_dbe
		output wire [31:0]  axi_extra_3_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_3_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_3_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_3_0_ruser_err_dbe, //       axi_extra_3_0.ruser_err_dbe
		output wire [31:0]  axi_extra_3_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_3_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_3_0_wuser_strb,    //                    .wuser_strb
		input  wire [15:0]  apb_2_ur_paddr,              //               apb_2.ur_paddr
		input  wire         apb_2_ur_psel,               //                    .ur_psel
		input  wire         apb_2_ur_penable,            //                    .ur_penable
		input  wire         apb_2_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_2_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_2_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_2_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_2_ur_prdata,             //                    .ur_prdata
		input  wire [15:0]  apb_3_ur_paddr,              //               apb_3.ur_paddr
		input  wire         apb_3_ur_psel,               //                    .ur_psel
		input  wire         apb_3_ur_penable,            //                    .ur_penable
		input  wire         apb_3_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_3_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_3_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_3_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_3_ur_prdata,             //                    .ur_prdata
		output wire         wmc_clk_4_clk,               //           wmc_clk_4.clk
		output wire         wmc_clk_5_clk,               //           wmc_clk_5.clk
		output wire         phy_clk_4_clk,               //           phy_clk_4.clk
		output wire         phy_clk_5_clk,               //           phy_clk_5.clk
		output wire         wmcrst_n_4_reset_n,          //          wmcrst_n_4.reset_n
		output wire         wmcrst_n_5_reset_n,          //          wmcrst_n_5.reset_n
		input  wire [8:0]   axi_4_1_awid,                //             axi_4_1.awid
		input  wire [27:0]  axi_4_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_4_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_4_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_4_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_4_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_4_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_4_1_awuser,              //                    .awuser
		input  wire         axi_4_1_awvalid,             //                    .awvalid
		output wire         axi_4_1_awready,             //                    .awready
		input  wire [255:0] axi_4_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_4_1_wstrb,               //                    .wstrb
		input  wire         axi_4_1_wlast,               //                    .wlast
		input  wire         axi_4_1_wvalid,              //                    .wvalid
		output wire         axi_4_1_wready,              //                    .wready
		output wire [8:0]   axi_4_1_bid,                 //                    .bid
		output wire [1:0]   axi_4_1_bresp,               //                    .bresp
		output wire         axi_4_1_bvalid,              //                    .bvalid
		input  wire         axi_4_1_bready,              //                    .bready
		input  wire [8:0]   axi_4_1_arid,                //                    .arid
		input  wire [27:0]  axi_4_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_4_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_4_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_4_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_4_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_4_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_4_1_aruser,              //                    .aruser
		input  wire         axi_4_1_arvalid,             //                    .arvalid
		output wire         axi_4_1_arready,             //                    .arready
		output wire [8:0]   axi_4_1_rid,                 //                    .rid
		output wire [255:0] axi_4_1_rdata,               //                    .rdata
		output wire [1:0]   axi_4_1_rresp,               //                    .rresp
		output wire         axi_4_1_rlast,               //                    .rlast
		output wire         axi_4_1_rvalid,              //                    .rvalid
		input  wire         axi_4_1_rready,              //                    .rready
		input  wire [8:0]   axi_4_0_awid,                //             axi_4_0.awid
		input  wire [27:0]  axi_4_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_4_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_4_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_4_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_4_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_4_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_4_0_awuser,              //                    .awuser
		input  wire         axi_4_0_awvalid,             //                    .awvalid
		output wire         axi_4_0_awready,             //                    .awready
		input  wire [255:0] axi_4_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_4_0_wstrb,               //                    .wstrb
		input  wire         axi_4_0_wlast,               //                    .wlast
		input  wire         axi_4_0_wvalid,              //                    .wvalid
		output wire         axi_4_0_wready,              //                    .wready
		output wire [8:0]   axi_4_0_bid,                 //                    .bid
		output wire [1:0]   axi_4_0_bresp,               //                    .bresp
		output wire         axi_4_0_bvalid,              //                    .bvalid
		input  wire         axi_4_0_bready,              //                    .bready
		input  wire [8:0]   axi_4_0_arid,                //                    .arid
		input  wire [27:0]  axi_4_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_4_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_4_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_4_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_4_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_4_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_4_0_aruser,              //                    .aruser
		input  wire         axi_4_0_arvalid,             //                    .arvalid
		output wire         axi_4_0_arready,             //                    .arready
		output wire [8:0]   axi_4_0_rid,                 //                    .rid
		output wire [255:0] axi_4_0_rdata,               //                    .rdata
		output wire [1:0]   axi_4_0_rresp,               //                    .rresp
		output wire         axi_4_0_rlast,               //                    .rlast
		output wire         axi_4_0_rvalid,              //                    .rvalid
		input  wire         axi_4_0_rready,              //                    .rready
		input  wire [8:0]   axi_5_1_awid,                //             axi_5_1.awid
		input  wire [27:0]  axi_5_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_5_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_5_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_5_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_5_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_5_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_5_1_awuser,              //                    .awuser
		input  wire         axi_5_1_awvalid,             //                    .awvalid
		output wire         axi_5_1_awready,             //                    .awready
		input  wire [255:0] axi_5_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_5_1_wstrb,               //                    .wstrb
		input  wire         axi_5_1_wlast,               //                    .wlast
		input  wire         axi_5_1_wvalid,              //                    .wvalid
		output wire         axi_5_1_wready,              //                    .wready
		output wire [8:0]   axi_5_1_bid,                 //                    .bid
		output wire [1:0]   axi_5_1_bresp,               //                    .bresp
		output wire         axi_5_1_bvalid,              //                    .bvalid
		input  wire         axi_5_1_bready,              //                    .bready
		input  wire [8:0]   axi_5_1_arid,                //                    .arid
		input  wire [27:0]  axi_5_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_5_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_5_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_5_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_5_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_5_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_5_1_aruser,              //                    .aruser
		input  wire         axi_5_1_arvalid,             //                    .arvalid
		output wire         axi_5_1_arready,             //                    .arready
		output wire [8:0]   axi_5_1_rid,                 //                    .rid
		output wire [255:0] axi_5_1_rdata,               //                    .rdata
		output wire [1:0]   axi_5_1_rresp,               //                    .rresp
		output wire         axi_5_1_rlast,               //                    .rlast
		output wire         axi_5_1_rvalid,              //                    .rvalid
		input  wire         axi_5_1_rready,              //                    .rready
		input  wire [8:0]   axi_5_0_awid,                //             axi_5_0.awid
		input  wire [27:0]  axi_5_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_5_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_5_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_5_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_5_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_5_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_5_0_awuser,              //                    .awuser
		input  wire         axi_5_0_awvalid,             //                    .awvalid
		output wire         axi_5_0_awready,             //                    .awready
		input  wire [255:0] axi_5_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_5_0_wstrb,               //                    .wstrb
		input  wire         axi_5_0_wlast,               //                    .wlast
		input  wire         axi_5_0_wvalid,              //                    .wvalid
		output wire         axi_5_0_wready,              //                    .wready
		output wire [8:0]   axi_5_0_bid,                 //                    .bid
		output wire [1:0]   axi_5_0_bresp,               //                    .bresp
		output wire         axi_5_0_bvalid,              //                    .bvalid
		input  wire         axi_5_0_bready,              //                    .bready
		input  wire [8:0]   axi_5_0_arid,                //                    .arid
		input  wire [27:0]  axi_5_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_5_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_5_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_5_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_5_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_5_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_5_0_aruser,              //                    .aruser
		input  wire         axi_5_0_arvalid,             //                    .arvalid
		output wire         axi_5_0_arready,             //                    .arready
		output wire [8:0]   axi_5_0_rid,                 //                    .rid
		output wire [255:0] axi_5_0_rdata,               //                    .rdata
		output wire [1:0]   axi_5_0_rresp,               //                    .rresp
		output wire         axi_5_0_rlast,               //                    .rlast
		output wire         axi_5_0_rvalid,              //                    .rvalid
		input  wire         axi_5_0_rready,              //                    .rready
		output wire         axi_extra_4_1_ruser_err_dbe, //       axi_extra_4_1.ruser_err_dbe
		output wire [31:0]  axi_extra_4_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_4_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_4_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_4_0_ruser_err_dbe, //       axi_extra_4_0.ruser_err_dbe
		output wire [31:0]  axi_extra_4_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_4_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_4_0_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_5_1_ruser_err_dbe, //       axi_extra_5_1.ruser_err_dbe
		output wire [31:0]  axi_extra_5_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_5_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_5_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_5_0_ruser_err_dbe, //       axi_extra_5_0.ruser_err_dbe
		output wire [31:0]  axi_extra_5_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_5_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_5_0_wuser_strb,    //                    .wuser_strb
		input  wire [15:0]  apb_4_ur_paddr,              //               apb_4.ur_paddr
		input  wire         apb_4_ur_psel,               //                    .ur_psel
		input  wire         apb_4_ur_penable,            //                    .ur_penable
		input  wire         apb_4_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_4_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_4_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_4_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_4_ur_prdata,             //                    .ur_prdata
		input  wire [15:0]  apb_5_ur_paddr,              //               apb_5.ur_paddr
		input  wire         apb_5_ur_psel,               //                    .ur_psel
		input  wire         apb_5_ur_penable,            //                    .ur_penable
		input  wire         apb_5_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_5_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_5_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_5_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_5_ur_prdata,             //                    .ur_prdata
		output wire         wmc_clk_6_clk,               //           wmc_clk_6.clk
		output wire         wmc_clk_7_clk,               //           wmc_clk_7.clk
		output wire         phy_clk_6_clk,               //           phy_clk_6.clk
		output wire         phy_clk_7_clk,               //           phy_clk_7.clk
		output wire         wmcrst_n_6_reset_n,          //          wmcrst_n_6.reset_n
		output wire         wmcrst_n_7_reset_n,          //          wmcrst_n_7.reset_n
		input  wire [8:0]   axi_6_1_awid,                //             axi_6_1.awid
		input  wire [27:0]  axi_6_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_6_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_6_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_6_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_6_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_6_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_6_1_awuser,              //                    .awuser
		input  wire         axi_6_1_awvalid,             //                    .awvalid
		output wire         axi_6_1_awready,             //                    .awready
		input  wire [255:0] axi_6_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_6_1_wstrb,               //                    .wstrb
		input  wire         axi_6_1_wlast,               //                    .wlast
		input  wire         axi_6_1_wvalid,              //                    .wvalid
		output wire         axi_6_1_wready,              //                    .wready
		output wire [8:0]   axi_6_1_bid,                 //                    .bid
		output wire [1:0]   axi_6_1_bresp,               //                    .bresp
		output wire         axi_6_1_bvalid,              //                    .bvalid
		input  wire         axi_6_1_bready,              //                    .bready
		input  wire [8:0]   axi_6_1_arid,                //                    .arid
		input  wire [27:0]  axi_6_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_6_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_6_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_6_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_6_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_6_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_6_1_aruser,              //                    .aruser
		input  wire         axi_6_1_arvalid,             //                    .arvalid
		output wire         axi_6_1_arready,             //                    .arready
		output wire [8:0]   axi_6_1_rid,                 //                    .rid
		output wire [255:0] axi_6_1_rdata,               //                    .rdata
		output wire [1:0]   axi_6_1_rresp,               //                    .rresp
		output wire         axi_6_1_rlast,               //                    .rlast
		output wire         axi_6_1_rvalid,              //                    .rvalid
		input  wire         axi_6_1_rready,              //                    .rready
		input  wire [8:0]   axi_6_0_awid,                //             axi_6_0.awid
		input  wire [27:0]  axi_6_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_6_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_6_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_6_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_6_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_6_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_6_0_awuser,              //                    .awuser
		input  wire         axi_6_0_awvalid,             //                    .awvalid
		output wire         axi_6_0_awready,             //                    .awready
		input  wire [255:0] axi_6_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_6_0_wstrb,               //                    .wstrb
		input  wire         axi_6_0_wlast,               //                    .wlast
		input  wire         axi_6_0_wvalid,              //                    .wvalid
		output wire         axi_6_0_wready,              //                    .wready
		output wire [8:0]   axi_6_0_bid,                 //                    .bid
		output wire [1:0]   axi_6_0_bresp,               //                    .bresp
		output wire         axi_6_0_bvalid,              //                    .bvalid
		input  wire         axi_6_0_bready,              //                    .bready
		input  wire [8:0]   axi_6_0_arid,                //                    .arid
		input  wire [27:0]  axi_6_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_6_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_6_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_6_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_6_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_6_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_6_0_aruser,              //                    .aruser
		input  wire         axi_6_0_arvalid,             //                    .arvalid
		output wire         axi_6_0_arready,             //                    .arready
		output wire [8:0]   axi_6_0_rid,                 //                    .rid
		output wire [255:0] axi_6_0_rdata,               //                    .rdata
		output wire [1:0]   axi_6_0_rresp,               //                    .rresp
		output wire         axi_6_0_rlast,               //                    .rlast
		output wire         axi_6_0_rvalid,              //                    .rvalid
		input  wire         axi_6_0_rready,              //                    .rready
		input  wire [8:0]   axi_7_1_awid,                //             axi_7_1.awid
		input  wire [27:0]  axi_7_1_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_7_1_awlen,               //                    .awlen
		input  wire [2:0]   axi_7_1_awsize,              //                    .awsize
		input  wire [1:0]   axi_7_1_awburst,             //                    .awburst
		input  wire [2:0]   axi_7_1_awprot,              //                    .awprot
		input  wire [3:0]   axi_7_1_awqos,               //                    .awqos
		input  wire [0:0]   axi_7_1_awuser,              //                    .awuser
		input  wire         axi_7_1_awvalid,             //                    .awvalid
		output wire         axi_7_1_awready,             //                    .awready
		input  wire [255:0] axi_7_1_wdata,               //                    .wdata
		input  wire [31:0]  axi_7_1_wstrb,               //                    .wstrb
		input  wire         axi_7_1_wlast,               //                    .wlast
		input  wire         axi_7_1_wvalid,              //                    .wvalid
		output wire         axi_7_1_wready,              //                    .wready
		output wire [8:0]   axi_7_1_bid,                 //                    .bid
		output wire [1:0]   axi_7_1_bresp,               //                    .bresp
		output wire         axi_7_1_bvalid,              //                    .bvalid
		input  wire         axi_7_1_bready,              //                    .bready
		input  wire [8:0]   axi_7_1_arid,                //                    .arid
		input  wire [27:0]  axi_7_1_araddr,              //                    .araddr
		input  wire [7:0]   axi_7_1_arlen,               //                    .arlen
		input  wire [2:0]   axi_7_1_arsize,              //                    .arsize
		input  wire [1:0]   axi_7_1_arburst,             //                    .arburst
		input  wire [2:0]   axi_7_1_arprot,              //                    .arprot
		input  wire [3:0]   axi_7_1_arqos,               //                    .arqos
		input  wire [0:0]   axi_7_1_aruser,              //                    .aruser
		input  wire         axi_7_1_arvalid,             //                    .arvalid
		output wire         axi_7_1_arready,             //                    .arready
		output wire [8:0]   axi_7_1_rid,                 //                    .rid
		output wire [255:0] axi_7_1_rdata,               //                    .rdata
		output wire [1:0]   axi_7_1_rresp,               //                    .rresp
		output wire         axi_7_1_rlast,               //                    .rlast
		output wire         axi_7_1_rvalid,              //                    .rvalid
		input  wire         axi_7_1_rready,              //                    .rready
		input  wire [8:0]   axi_7_0_awid,                //             axi_7_0.awid
		input  wire [27:0]  axi_7_0_awaddr,              //                    .awaddr
		input  wire [7:0]   axi_7_0_awlen,               //                    .awlen
		input  wire [2:0]   axi_7_0_awsize,              //                    .awsize
		input  wire [1:0]   axi_7_0_awburst,             //                    .awburst
		input  wire [2:0]   axi_7_0_awprot,              //                    .awprot
		input  wire [3:0]   axi_7_0_awqos,               //                    .awqos
		input  wire [0:0]   axi_7_0_awuser,              //                    .awuser
		input  wire         axi_7_0_awvalid,             //                    .awvalid
		output wire         axi_7_0_awready,             //                    .awready
		input  wire [255:0] axi_7_0_wdata,               //                    .wdata
		input  wire [31:0]  axi_7_0_wstrb,               //                    .wstrb
		input  wire         axi_7_0_wlast,               //                    .wlast
		input  wire         axi_7_0_wvalid,              //                    .wvalid
		output wire         axi_7_0_wready,              //                    .wready
		output wire [8:0]   axi_7_0_bid,                 //                    .bid
		output wire [1:0]   axi_7_0_bresp,               //                    .bresp
		output wire         axi_7_0_bvalid,              //                    .bvalid
		input  wire         axi_7_0_bready,              //                    .bready
		input  wire [8:0]   axi_7_0_arid,                //                    .arid
		input  wire [27:0]  axi_7_0_araddr,              //                    .araddr
		input  wire [7:0]   axi_7_0_arlen,               //                    .arlen
		input  wire [2:0]   axi_7_0_arsize,              //                    .arsize
		input  wire [1:0]   axi_7_0_arburst,             //                    .arburst
		input  wire [2:0]   axi_7_0_arprot,              //                    .arprot
		input  wire [3:0]   axi_7_0_arqos,               //                    .arqos
		input  wire [0:0]   axi_7_0_aruser,              //                    .aruser
		input  wire         axi_7_0_arvalid,             //                    .arvalid
		output wire         axi_7_0_arready,             //                    .arready
		output wire [8:0]   axi_7_0_rid,                 //                    .rid
		output wire [255:0] axi_7_0_rdata,               //                    .rdata
		output wire [1:0]   axi_7_0_rresp,               //                    .rresp
		output wire         axi_7_0_rlast,               //                    .rlast
		output wire         axi_7_0_rvalid,              //                    .rvalid
		input  wire         axi_7_0_rready,              //                    .rready
		output wire         axi_extra_6_1_ruser_err_dbe, //       axi_extra_6_1.ruser_err_dbe
		output wire [31:0]  axi_extra_6_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_6_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_6_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_6_0_ruser_err_dbe, //       axi_extra_6_0.ruser_err_dbe
		output wire [31:0]  axi_extra_6_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_6_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_6_0_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_7_1_ruser_err_dbe, //       axi_extra_7_1.ruser_err_dbe
		output wire [31:0]  axi_extra_7_1_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_7_1_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_7_1_wuser_strb,    //                    .wuser_strb
		output wire         axi_extra_7_0_ruser_err_dbe, //       axi_extra_7_0.ruser_err_dbe
		output wire [31:0]  axi_extra_7_0_ruser_data,    //                    .ruser_data
		input  wire [31:0]  axi_extra_7_0_wuser_data,    //                    .wuser_data
		input  wire [3:0]   axi_extra_7_0_wuser_strb,    //                    .wuser_strb
		input  wire [15:0]  apb_6_ur_paddr,              //               apb_6.ur_paddr
		input  wire         apb_6_ur_psel,               //                    .ur_psel
		input  wire         apb_6_ur_penable,            //                    .ur_penable
		input  wire         apb_6_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_6_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_6_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_6_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_6_ur_prdata,             //                    .ur_prdata
		input  wire [15:0]  apb_7_ur_paddr,              //               apb_7.ur_paddr
		input  wire         apb_7_ur_psel,               //                    .ur_psel
		input  wire         apb_7_ur_penable,            //                    .ur_penable
		input  wire         apb_7_ur_pwrite,             //                    .ur_pwrite
		input  wire [15:0]  apb_7_ur_pwdata,             //                    .ur_pwdata
		input  wire [1:0]   apb_7_ur_pstrb,              //                    .ur_pstrb
		output wire         apb_7_ur_prready,            //                    .ur_prready
		output wire [15:0]  apb_7_ur_prdata              //                    .ur_prdata
	);
endmodule

