
namespace eval g_pciecore_sgxx {
  proc get_design_libraries {} {
    set libraries [dict create]
    dict set libraries altera_common_sv_packages           1
    dict set libraries altera_xcvr_native_s10_htile_1930   1
    dict set libraries altera_xcvr_pcie_hip_native_s10_191 1
    dict set libraries altera_pcie_s10_hip_ast_2300        1
    dict set libraries altera_xcvr_fpll_s10_htile_1912     1
    dict set libraries altera_xcvr_atx_pll_s10_htile_1911  1
    dict set libraries g_pciecore_sgxx                     1
    return $libraries
  }
  
  proc get_memory_files {QSYS_SIMDIR} {
    set memory_files [list]
    return $memory_files
  }
  
  proc get_common_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [dict create]
    dict set design_files "altera_common_sv_packages::altera_xcvr_native_s10_functions_h" "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_xcvr_native_s10_functions_h.sv"]\"  -work altera_common_sv_packages"
    return $design_files
  }
  
  proc get_design_files {USER_DEFINED_COMPILE_OPTIONS USER_DEFINED_VERILOG_COMPILE_OPTIONS USER_DEFINED_VHDL_COMPILE_OPTIONS QSYS_SIMDIR} {
    set design_files [list]
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_ybjngbq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_ybjngbq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_jnjlkka.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_dade52y.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_dade52y.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_arp7aba.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_y7bszui.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_y7bszui.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_ym6kcby.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_yajrmla.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_yajrmla.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_ptgqyjy.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_efrfmxq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_efrfmxq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_6v7kgma.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_d3aedhi.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_d3aedhi.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_qlx3ufy.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_drnl4hi.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_drnl4hi.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_wer2ohq.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_ubfbwgi.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_ubfbwgi.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_div7ici.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_2judtnq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_2judtnq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_zbre65a.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_srjopaa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_srjopaa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_gtuxyyq.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_o57vwri.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_o57vwri.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_uecrppq.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_5v4waxa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_5v4waxa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_sesfyli.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_do5kjpq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_do5kjpq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_5vbu3cq.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_a7rtrua.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_a7rtrua.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_rnqhj6q.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_6557pta.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_6557pta.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_lrwbjgi.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/mentor/alt_xcvr_reset_counter_s10.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_prbs_accum.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_odi_accel.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_early_spd_chng_s10_htile.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_anlg_reset_seq_wrapper.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_re_cal_chnl.v"]\"  -work altera_xcvr_native_s10_htile_1930"                                                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_pcie_rx_eios_prot.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rx_maib_wa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/g_pciecore_sgxx_altera_xcvr_native_s10_htile_1930_4ntkvxa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_native_s10_htile_1930/sim/alt_xcvr_native_rcfg_opt_logic_4ntkvxa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_native_s10_htile_1930"                         
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_altera_xcvr_native_s10_htile_191_lcmk7ty.v"]\"  -work altera_xcvr_pcie_hip_native_s10_191"    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/g_pciecore_sgxx_altera_xcvr_pcie_hip_native_s10_191_y3ajxpq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_pcie_hip_native_s10_191"
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/alt_xcvr_native_dig_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_pcie_hip_native_s10_191"                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_pcie_hip_native_s10_191/sim/alt_xcvr_resync_std.sv"]\" -L altera_common_sv_packages -work altera_xcvr_pcie_hip_native_s10_191"                                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/g_pciecore_sgxx_altera_pcie_s10_hip_ast_altera_xcvr_pcie_hip_native_s10_2300_5fdftii.v"]\"  -work altera_pcie_s10_hip_ast_2300"                      
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_fpll_s10_htile_1912"                                                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                                         
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                     
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_pll_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_pll_embedded_debug.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                        
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_pll_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_resync.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                                    
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/mentor/alt_xcvr_resync.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                             
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/g_pciecore_sgxx_altera_xcvr_fpll_s10_htile_1912_x2hfk6a.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"            
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_fpll_s10_htile_1912/sim/alt_xcvr_pll_rcfg_opt_logic_x2hfk6a.sv"]\" -L altera_common_sv_packages -work altera_xcvr_fpll_s10_htile_1912"                                
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/g_pciecore_sgxx_altera_pcie_s10_hip_ast_altera_xcvr_fpll_s10_htile_2300_kerjnma.v"]\"  -work altera_pcie_s10_hip_ast_2300"                           
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_xcvr_atx_pll_s10_htile_1911"                                                                 
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_resync.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                              
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                             
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/mentor/alt_xcvr_resync.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                       
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/mentor/alt_xcvr_arbiter.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                      
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/s10_avmm_h.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                                   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_native_anlg_reset_seq.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                               
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_pll_rcfg_arb.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                        
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_pll_embedded_debug.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                  
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_pll_avmm_csr.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                                        
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/g_pciecore_sgxx_altera_xcvr_atx_pll_s10_htile_1911_qdqzlqa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"   
    lappend design_files "vlog -sv $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_xcvr_atx_pll_s10_htile_1911/sim/alt_xcvr_pll_rcfg_opt_logic_qdqzlqa.sv"]\" -L altera_common_sv_packages -work altera_xcvr_atx_pll_s10_htile_1911"                          
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/g_pciecore_sgxx_altera_pcie_s10_hip_ast_altera_xcvr_atx_pll_s10_htile_2300_zv6o33i.v"]\"  -work altera_pcie_s10_hip_ast_2300"                        
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_hip_ast_2300_kipasgq.sv"]\"  -work altera_pcie_s10_hip_ast_2300"                                                                     
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_hip_ast_pllnphy_2300_kipasgq.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                              
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_hip_ast_pllnphy_2300_kipasgq.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                              
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_hip_ast_pipen1b_2300_kipasgq.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                              
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_hip_ast_pipen1b_2300_kipasgq.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                              
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_reset_delay_sync.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                                          
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_pcie_s10_sc_bitsync.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                                                
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/../altera_pcie_s10_hip_ast_2300/sim/altera_std_synchronizer_nocut.v"]\"  -work altera_pcie_s10_hip_ast_2300"                                                                             
    lappend design_files "vlog $USER_DEFINED_VERILOG_COMPILE_OPTIONS $USER_DEFINED_COMPILE_OPTIONS  \"[normalize_path "$QSYS_SIMDIR/g_pciecore_sgxx.v"]\"  -work g_pciecore_sgxx"                                                                                                                                            
    return $design_files
  }
  
  proc get_elab_options {SIMULATOR_TOOL_BITNESS} {
    set ELAB_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ELAB_OPTIONS
  }
  
  
  proc get_sim_options {SIMULATOR_TOOL_BITNESS} {
    set SIM_OPTIONS ""
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $SIM_OPTIONS
  }
  
  
  proc get_env_variables {SIMULATOR_TOOL_BITNESS} {
    set ENV_VARIABLES [dict create]
    set LD_LIBRARY_PATH [dict create]
    dict set ENV_VARIABLES "LD_LIBRARY_PATH" $LD_LIBRARY_PATH
    if ![ string match "bit_64" $SIMULATOR_TOOL_BITNESS ] {
    } else {
    }
    return $ENV_VARIABLES
  }
  
  
  proc normalize_path {FILEPATH} {
      if {[catch { package require fileutil } err]} { 
          return $FILEPATH 
      } 
      set path [fileutil::lexnormalize [file join [pwd] $FILEPATH]]  
      if {[file pathtype $FILEPATH] eq "relative"} { 
          set path [fileutil::relative [pwd] $path] 
      } 
      return $path 
  } 
}
