  
 //******************************************************************************************
 //*  COMPANY    :  ________                                                                *
 //*  NAME       :  compassys                                                               *
 //*  BOARD      :  Proc10N                                                                 *
 //*  IC#        :  1                                                                       *
 //*  Created    :  Wed Mar 05 23:30:21 2025                                                *
 //*  This file  was  generated by  ProcWizard Application  version 9.8.7.3                 *
 //*  Copyright (C) 2025. All Rights Reserved to Gidel Ltd                                  *
 //*  For support contact: support@gidel.com, USA: 408-969-0389, Israel: +972-4-6102-500    *
 //******************************************************************************************
  
  
  
  
  
 module  ic_tcorearray
 (
      //======================================================================
      //=                      Clocks & Global signals                       =
      //======================================================================
        input               clk_125m,           // 125 MHz reference clock input pin
        input               Gck0,               // 322.265625 MHz, high speed accurate clocks from external clock generator (dedicated clock on bank 4M - REFCK_GX4M_CHTp)
        input               Gck1,               // 322.265625 MHz, high speed accurate clocks from external clock generator (dedicated clock on bank 4D - REFCK_GX4D_CHTp)
        input               Gck2,               // 322.265625 MHz, high speed accurate clocks from external clock generator (dedicated clock on bank 1M - REFCK_GX1M_CHBp)
        input               Gck3,               // 125 MHz, high speed accurate clocks from external clock generator (dedicated clock on bank 1F - REFCK_GX1F_CHBp)
        output      [1:0]   clk2pll,            // output ref clocks to external clock generator (IN1:IN0)
        input               hbm_clk_top,        // input High Bandwidth Memory clocks (on the top of the FPGA)
        output      [1:0]   status_ledno,       // Status LED; 0: light on (led[0]-is green, led[1]-is red)
        output              status_1C_ledo,     // Status LED; 1: light on (red led on the Proc1C carrier)
        output              clk0_vpin,          // Main system clock (virtual pin)
        output              clk_vpin,           // User clock (virtual pin)
        output              clk2_vpin,          // Is an auxiliary clock (virtual pin)
        inout       [2:0]   g_reserved,         // Gidel reserved IO bus
        input       [17:0]  g_reservedi,        // Gidel reserved Input bus
        output      [7:1]   g_reservedo,        // Gidel reserved Output bus
        input       [2:0]   Cid,                // Carrier ID
        input               carrier_PG,         // 1C Carrier power good status; 1: status is OK (Proc1C carrier finished the power UP sequence)
      //======================================================================
      //= Dual color LEDs are placed on the bracket for indicating activity  =
      //======================================================================
        output      [2:1]   act_led_greenn,     // General Purpose User LEDs; 0: light on
        output      [2:1]   act_led_redn,       // General Purpose User LEDs; 0: light on
        output      [2:1]   act_led_1c_greenn,  // PROC_1C General Purpose User LEDs; 0: light on
        output      [2:1]   act_led_1c_redn,    // PROC_1C General Purpose User LEDs; 0: light on
      //======================================================================
      //=                       PCIe Bus Connections                         =
      //======================================================================
        input               pcie_refclk,        // Reference clock to the Hard IP for PCI Express
        input               pcie_perst,         // Active low reset from the PCIe reset pin of the device
        input       [15:0]  pcie_rx,            // Receive inputs. These signals are the serial inputs of lanes 15:0
        output      [15:0]  pcie_tx,            // Transmit outputs. These signals are the serial outputs of lanes 15:0
      //======================================================================
      //=                       HBM block (on a TOP)                         =
      //======================================================================
        input               cattrip_top,        // HBM2 signals common to each HBM2 interface;
        input       [2:0]   temp_top,           // these signals must be brought out to the design
        input       [7:0]   wso_top,            // top level. You do not need to drive these signals
        input               L_id,
        input               L_prsntL,
      //======================================================================
      //=                          Right connector                           =
      //======================================================================
        input               Gck_pll,            // 25 MHz, accurate clocks from external clock generator (dedicated clocks on banks: REFCK_GX1N_CHBp)
      //======================================================================
      //=                     External connector I/O's                       =
      //======================================================================
        input       [6:5]   J13_rs422_in,       // Input pins from RS422 receiver (the source of the signals is J13, refer to the board Data-book for the connector pin-out)
        output      [2:1]   J13_hv_drv_o,       // Output pins to UART voltage translation (the destination of the signals is J13, refer to the board Data-book for the connector pin-out)
        inout       [11:0]  ext_io,             // *** In-Computer *** LVTTL general-purpose I/O bus
        input       [4:2]   J13_opt_in,         // Input pin from Opto-couplers (the source of the signal is J13: pin 6 -OPTO2A, pin 5 -OPTO2C, pin 8 -OPTO3A, pin 7 -OPTO3C, pin 10 -OPTO4A, pin 9 -OPTO4C)
        inout               lvttl_io,           // LVTTL(3.3V) bidirectional pin from J13-pin 12
        input               T_prsntL,
        input       [1:0]   T_id 
 );

   
   
   
 localparam        RBF_VERSION_VAL             =  'h 1;
 localparam        BUILD_VERSION_VAL           =  'h 1;
   
   
   
 //======================================================================
 //=                             W I R E s                              =
 //======================================================================
  
 // Clocks & Globals
  
 // Hardware status registers (FPGA->Host)
 wire    [31:0]           lat_counter;
 wire    [31:0]           err_info;
 wire    [7:0]            rbf_version;                       // RBF_Info[7..0]
 wire    [7:0]            build_version;                     // RBF_Info[15..8]
 wire                     almost_empty_host_rd_00;           // status_host_rd_00[0]
 wire                     almost_full_host_rd_00;            // status_host_rd_00[1]
 wire                     almost_full_host_wr_00;            // status_host_wr_00[1]
 wire                     almost_empty_host_rd_01;           // status_host_rd_01[0]
 wire                     almost_full_host_rd_01;            // status_host_rd_01[1]
 wire                     almost_full_host_wr_01;            // status_host_wr_01[1]
 wire                     almost_empty_host_rd_02;           // status_host_rd_02[0]
 wire                     almost_full_host_rd_02;            // status_host_rd_02[1]
 wire                     almost_full_host_wr_02;            // status_host_wr_02[1]
 wire                     almost_empty_host_rd_03;           // status_host_rd_03[0]
 wire                     almost_full_host_rd_03;            // status_host_rd_03[1]
 wire                     almost_full_host_wr_03;            // status_host_wr_03[1]
 wire                     almost_empty_host_rd_04;           // status_host_rd_04[0]
 wire                     almost_full_host_rd_04;            // status_host_rd_04[1]
 wire                     almost_full_host_wr_04;            // status_host_wr_04[1]
 wire                     almost_empty_host_rd_05;           // status_host_rd_05[0]
 wire                     almost_full_host_rd_05;            // status_host_rd_05[1]
 wire                     almost_full_host_wr_05;            // status_host_wr_05[1]
 wire                     almost_empty_host_rd_20;           // status_host_rd_20[0]
 wire                     almost_full_host_rd_20;            // status_host_rd_20[1]
 wire                     almost_full_host_wr_20;            // status_host_wr_20[1]
 wire                     almost_empty_host_rd_21;           // status_host_rd_21[0]
 wire                     almost_full_host_rd_21;            // status_host_rd_21[1]
 wire                     almost_full_host_wr_21;            // status_host_wr_21[1]
  
 // Mode registers (Host->FPGA). Use to set hardware working modes
 wire                     clk0;                              // Main system clock, the max frequency is 300 MHZ
 wire                     clk;                               // User clock, the frequency is twice/triply the frequency of clk0
 wire                     clk2;                              // Is an auxiliary clock that may be used as a slow emulation clock
 wire    [2:0]            id;                                // FPGA number identification
 wire    [99:0]           g_reserved_control;                // Gidel reserved control bus Please do not change.
 wire    [99:0]           g_reserved_status;                 // Gidel reserved status bus. Please do not change.
 wire    [99:0]           g_reserved_i;                      // Gidel reserved Input bus. Please do not change.
 wire    [99:0]           g_reserved_o;                      // Gidel reserved Output bus. Please do not change.
 wire    [1:0]            status_ledn;                       // Status LED; 0: light on
  
 // Internal Bus Interface Signals
 wire                     clrn;                              // User Global Clear   (0: clear all)
 wire                     lclk;                              // Local Bus Clock
 wire                     l_wr;                              // User Write Signal (1:write)
 wire    [31:0]           addr_wr;                           // Local bus address for write operations
 wire    [255:0]          l_data_wr;                         // User input local data bus
 wire                     mem_ready_wr;                      // 1: write memory data is valid (memory is ready)
 wire                     l_rd;                              // User Read Signal (0:read)
 wire    [31:0]           addr_rd;                           // Local bus address for read operations
 wire    [255:0]          l_data_rd;                         // Data to read back from device memories
 wire                     mem_ready_rd;                      // 1: End of data read transfer (memory data is valid)
 wire                     l_eos;                             // 1 - end of stream (EOS) flag of the last DMA transfer to user logic
 wire    [31:0]           l_be;                              // represent enable only for the remaining bytes at the EOS
  
 // User interrupt signals
 wire                     interrupt;                         // Interrupt signal - assert low to send interrupt to SoftWare, when interrupt_ack is high.
 wire                     interrupt_ack;                     // Interrupt acknowledge signal - asserted high to to enable user interrupt.
  
 // User DREQ signals
 wire    [31:0]           user_dreq;                         // DMA control - assert low to enable DMA operation, high to stop DMA (for each DMA channel).
  
 // Cyclic mode signals
 wire                     user_flush_rd;                     // Stop running READ DMA buffer and go to a next on the buffer list (for cyclic DMA mode only)
 wire    [4:0]            last_size_rd;                      // When flush is high this indicate the number of bytes in this last transfer
  
 // Other signals
  
 // Gidel Firmware signals
 wire    [4:0]            g_freserved_o;
 wire    [1023:0]         hbm_o[32];
 wire    [1023:0]         hbm_i[32];
  
 // ------------------------
 wire    [7:0]            tc_ctrl;                           // ctrl[7..0]
 wire    [15:0]           mbvec_size;                        // ctrl[23..8]
 wire    [31:0]           mbidx_rd_bound;
 wire    [31:0]           ma_rd_bound;
 wire    [31:0]           buf_ld_sel;
  
 // Select signals for user's memories / reggroups
 wire                     sel_cross_bar_00_host_rd_00;       // select for cross_bar_00_host_rd_00
 wire                     sel_start_cross_bar_00_host_rd_00; // select for start_cross_bar_00_host_rd_00
 wire                     sel_cross_bar_00_host_wr_00;       // select for cross_bar_00_host_wr_00
 wire                     sel_start_cross_bar_00_host_wr_00; // select for start_cross_bar_00_host_wr_00
 wire                     sel_cross_bar_01_host_rd_01;       // select for cross_bar_01_host_rd_01
 wire                     sel_start_cross_bar_01_host_rd_01; // select for start_cross_bar_01_host_rd_01
 wire                     sel_cross_bar_01_host_wr_01;       // select for cross_bar_01_host_wr_01
 wire                     sel_start_cross_bar_01_host_wr_01; // select for start_cross_bar_01_host_wr_01
 wire                     sel_cross_bar_02_host_rd_02;       // select for cross_bar_02_host_rd_02
 wire                     sel_start_cross_bar_02_host_rd_02; // select for start_cross_bar_02_host_rd_02
 wire                     sel_cross_bar_02_host_wr_02;       // select for cross_bar_02_host_wr_02
 wire                     sel_start_cross_bar_02_host_wr_02; // select for start_cross_bar_02_host_wr_02
 wire                     sel_cross_bar_03_host_rd_03;       // select for cross_bar_03_host_rd_03
 wire                     sel_start_cross_bar_03_host_rd_03; // select for start_cross_bar_03_host_rd_03
 wire                     sel_cross_bar_03_host_wr_03;       // select for cross_bar_03_host_wr_03
 wire                     sel_start_cross_bar_03_host_wr_03; // select for start_cross_bar_03_host_wr_03
 wire                     sel_cross_bar_04_host_rd_04;       // select for cross_bar_04_host_rd_04
 wire                     sel_start_cross_bar_04_host_rd_04; // select for start_cross_bar_04_host_rd_04
 wire                     sel_cross_bar_04_host_wr_04;       // select for cross_bar_04_host_wr_04
 wire                     sel_start_cross_bar_04_host_wr_04; // select for start_cross_bar_04_host_wr_04
 wire                     sel_cross_bar_05_host_rd_05;       // select for cross_bar_05_host_rd_05
 wire                     sel_start_cross_bar_05_host_rd_05; // select for start_cross_bar_05_host_rd_05
 wire                     sel_cross_bar_05_host_wr_05;       // select for cross_bar_05_host_wr_05
 wire                     sel_start_cross_bar_05_host_wr_05; // select for start_cross_bar_05_host_wr_05
 wire                     sel_cross_bar_20_host_rd_20;       // select for cross_bar_20_host_rd_20
 wire                     sel_start_cross_bar_20_host_rd_20; // select for start_cross_bar_20_host_rd_20
 wire                     sel_cross_bar_20_host_wr_20;       // select for cross_bar_20_host_wr_20
 wire                     sel_start_cross_bar_20_host_wr_20; // select for start_cross_bar_20_host_wr_20
 wire                     sel_cross_bar_21_host_rd_21;       // select for cross_bar_21_host_rd_21
 wire                     sel_start_cross_bar_21_host_rd_21; // select for start_cross_bar_21_host_rd_21
 wire                     sel_cross_bar_21_host_wr_21;       // select for cross_bar_21_host_wr_21
 wire                     sel_start_cross_bar_21_host_wr_21; // select for start_cross_bar_21_host_wr_21
  
  
 // PROCMultiPort cross_bar_00
 wire                     hbm_0_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_in_0;                // Port start (reset) signal
 wire                     select_tcarray_in_0;               // Port select (enable) signal
 wire    [255:0]          data_tcarray_in_0;                 // Data from port tcarray_in_0 of MultiPort cross_bar_00
 wire    [31:0]           addr_tcarray_in_0;                 // Port address input
 wire                     almost_empty_tcarray_in_0;         // Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
 wire                     port_error_tcarray_in_0;           // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_00;                   // Data from port host_rd_00 of MultiPort cross_bar_00
 wire                     port_error_host_rd_00;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_00_host_rd_00;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_00;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_00_host_wr_00;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_01
 wire                     hbm_1_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_in_1;                // Port start (reset) signal
 wire                     select_tcarray_in_1;               // Port select (enable) signal
 wire    [255:0]          data_tcarray_in_1;                 // Data from port tcarray_in_1 of MultiPort cross_bar_01
 wire    [31:0]           addr_tcarray_in_1;                 // Port address input
 wire                     almost_empty_tcarray_in_1;         // Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
 wire                     port_error_tcarray_in_1;           // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_01;                   // Data from port host_rd_01 of MultiPort cross_bar_01
 wire                     port_error_host_rd_01;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_01_host_rd_01;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_01;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_01_host_wr_01;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_02
 wire                     hbm_2_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_in_2;                // Port start (reset) signal
 wire                     select_tcarray_in_2;               // Port select (enable) signal
 wire    [255:0]          data_tcarray_in_2;                 // Data from port tcarray_in_2 of MultiPort cross_bar_02
 wire    [31:0]           addr_tcarray_in_2;                 // Port address input
 wire                     almost_empty_tcarray_in_2;         // Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
 wire                     port_error_tcarray_in_2;           // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_02;                   // Data from port host_rd_02 of MultiPort cross_bar_02
 wire                     port_error_host_rd_02;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_02_host_rd_02;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_02;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_02_host_wr_02;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_03
 wire                     hbm_3_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_in_3;                // Port start (reset) signal
 wire                     select_tcarray_in_3;               // Port select (enable) signal
 wire    [255:0]          data_tcarray_in_3;                 // Data from port tcarray_in_3 of MultiPort cross_bar_03
 wire    [31:0]           addr_tcarray_in_3;                 // Port address input
 wire                     almost_empty_tcarray_in_3;         // Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
 wire                     port_error_tcarray_in_3;           // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_03;                   // Data from port host_rd_03 of MultiPort cross_bar_03
 wire                     port_error_host_rd_03;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_03_host_rd_03;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_03;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_03_host_wr_03;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_04
 wire                     hbm_4_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_in_4;                // Port start (reset) signal
 wire                     select_tcarray_in_4;               // Port select (enable) signal
 wire    [255:0]          data_tcarray_in_4;                 // Data from port tcarray_in_4 of MultiPort cross_bar_04
 wire    [31:0]           addr_tcarray_in_4;                 // Port address input
 wire                     almost_empty_tcarray_in_4;         // Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
 wire                     almost_full_tcarray_in_4;          // Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
 wire                     port_error_tcarray_in_4;           // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_04;                   // Data from port host_rd_04 of MultiPort cross_bar_04
 wire                     port_error_host_rd_04;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_04_host_rd_04;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_04;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_04_host_wr_04;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_05
 wire                     hbm_5_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_in_5;                // Port start (reset) signal
 wire                     select_tcarray_in_5;               // Port select (enable) signal
 wire    [255:0]          data_tcarray_in_5;                 // Data from port tcarray_in_5 of MultiPort cross_bar_05
 wire    [31:0]           addr_tcarray_in_5;                 // Port address input
 wire                     almost_empty_tcarray_in_5;         // Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
 wire                     port_error_tcarray_in_5;           // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_05;                   // Data from port host_rd_05 of MultiPort cross_bar_05
 wire                     port_error_host_rd_05;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_05_host_rd_05;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_05;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_05_host_wr_05;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_20
 wire                     hbm_6_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_out_0;               // Port start (reset) signal
 wire                     select_tcarray_out_0;              // Port select (enable) signal
 wire    [255:0]          data_tcarray_out_0;                // Data to port tcarray_out_0 of MultiPort cross_bar_20
 wire    [31:0]           addr_tcarray_out_0;                // Port address input
 wire                     almost_full_tcarray_out_0;         // Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
 wire                     port_error_tcarray_out_0;          // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_20;                   // Data from port host_rd_20 of MultiPort cross_bar_20
 wire                     port_error_host_rd_20;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_20_host_rd_20;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_20;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_20_host_wr_20;    // DMA transfer hold request from the port
  
 // PROCMultiPort cross_bar_21
 wire                     hbm_7_ready;                       // 1: Memory controller is ready for use, 0: Initializing (due to reset)
 wire                     start_tcarray_out_1;               // Port start (reset) signal
 wire                     select_tcarray_out_1;              // Port select (enable) signal
 wire    [255:0]          data_tcarray_out_1;                // Data to port tcarray_out_1 of MultiPort cross_bar_21
 wire    [31:0]           addr_tcarray_out_1;                // Port address input
 wire                     almost_full_tcarray_out_1;         // Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
 wire                     port_error_tcarray_out_1;          // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire    [255:0]          data_host_rd_21;                   // Data from port host_rd_21 of MultiPort cross_bar_21
 wire                     port_error_host_rd_21;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_21_host_rd_21;    // DMA transfer hold request from the port
 wire                     port_error_host_wr_21;             // Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
 wire                     g_dreq_cross_bar_21_host_wr_21;    // DMA transfer hold request from the port
  
  
   
   
   
  //======================================================================
  //=    The Interface entity connections (connections to the host)      =
  //======================================================================
  ic_tcorearray_if  if_ic_tcorearray
  (
       // Clocks & Globals
       .ref_clk(clk_125m),                                // Input      125 MHz reference clock input pin
       .clk0(clk0),                                       // Output     Main system clock, the max frequency is 300 MHZ
       .clk(clk),                                         // Output     User clock, the frequency is twice/triply the frequency of clk0
       .clk2(clk2),                                       // Output     Is an auxiliary clock that may be used as a slow emulation clock
       .status_ledn(status_ledn[1:0]),                    // Output     Status LED; 0: Light on
       .id(id[2:0]),                                      // Output     FPGA number identification
       .g_reserved(g_reserved[2:0]),                      // Inout      Gidel reserved IO bus Please do not change.
       .g_reserved_control(g_reserved_control[99:0]),     // Output     Gidel reserved control bus (out) Please do not change.
       .g_reserved_status(g_reserved_status[99:0]),       // Input      Gidel reserved status bus (input). Please do not change.
       .g_reserved_i(g_reserved_i[99:0]),                 // Input      Gidel reserved input bus. Please do not change.
       .g_reserved_o(g_reserved_o[99:0]),                 // Output     Gidel reserved output bus. Please do not change.
        
       // PCIe connection
       .pcie_refclk(pcie_refclk),                         // Input      Reference clock for the Hard IP for PCI Express
       .pcie_perst(pcie_perst),                           // Input      Active low reset from the PCIe reset pin of the device
       .pcie_rx(pcie_rx[15:0]),                           // Input      Receive inputs. These signals are the serial inputs of lanes 15:0
       .pcie_tx(pcie_tx[15:0]),                           // Output     Transmit outputs. These signals are the serial outputs of lanes 15:0
        
       // Internal Bus Interface Signals
       .clrn(clrn),                                       // Output     User Global Clear   (0: Clear all)
       .lclk(lclk),                                       // Output     Local Bus Clock
       .l_wr(l_wr),                                       // Output     User Write Signal (1:write)
       .addr_wr(addr_wr[31:0]),                           // Output     Local bus address for write operations (including burst auto address increment)
       .l_data_wr(l_data_wr[255:0]),                      // Output     User input local data bus
       .mem_ready_wr(mem_ready_wr),                       // Input      1: end of data write transfer (memory data is valid) on rising edge of lclk
       .l_rd(l_rd),                                       // Output     User Read Signal (0:read)
       .addr_rd(addr_rd[31:0]),                           // Output     Local bus address for read operations (including burst auto address increment)
       .l_data_rd(l_data_rd[255:0]),                      // Input      Data to read back from device memories
       .mem_ready_rd(mem_ready_rd),                       // Input      1: End of data read transfer (memory data is valid) on rising edge of lclk
       .l_eos(l_eos),                                     // Output     1 - end of stream (EOS) flag of the last DMA transfer to user logic
       .l_be(l_be[31:0]),                                 // Output     represent enable only for the remaining bytes at the EOS
        
       // Interrupt Logic
       .interrupt(interrupt),                             // Input      User interrupt
       .interrupt_ack(interrupt_ack),                     // Output     User interrupt acknowledge
        
       // DREQ Logic
       .user_dreq(user_dreq[31:0]),                       // Input      User DMA control for each DMA channel
        
       // Cyclic mode signals
       .user_flush_rd(user_flush_rd),                     // Input      Stop running READ DMA buffer and go to a next on the buffer list (for cyclic DMA mode only)
       .last_size_rd(last_size_rd[4:0]),                  // Input      When flush is high this indicate the number of bytes in this last transfer
        
       // Hardware status registers (FPGA->Host)
       .lat_counter(lat_counter[31:0]),                   // Input
       .err_info(err_info[31:0]),                         // Input
       .rbf_version(rbf_version[7:0]),                    // Input      RBF_Info[7..0]
       .build_version(build_version[7:0]),                // Input      RBF_Info[15..8]
       .almost_empty_host_rd_00(almost_empty_host_rd_00),  // Input     status_host_rd_00[0]
       .almost_full_host_rd_00(almost_full_host_rd_00),   // Input      status_host_rd_00[1]
       .almost_full_host_wr_00(almost_full_host_wr_00),   // Input      status_host_wr_00[1]
       .almost_empty_host_rd_01(almost_empty_host_rd_01),  // Input     status_host_rd_01[0]
       .almost_full_host_rd_01(almost_full_host_rd_01),   // Input      status_host_rd_01[1]
       .almost_full_host_wr_01(almost_full_host_wr_01),   // Input      status_host_wr_01[1]
       .almost_empty_host_rd_02(almost_empty_host_rd_02),  // Input     status_host_rd_02[0]
       .almost_full_host_rd_02(almost_full_host_rd_02),   // Input      status_host_rd_02[1]
       .almost_full_host_wr_02(almost_full_host_wr_02),   // Input      status_host_wr_02[1]
       .almost_empty_host_rd_03(almost_empty_host_rd_03),  // Input     status_host_rd_03[0]
       .almost_full_host_rd_03(almost_full_host_rd_03),   // Input      status_host_rd_03[1]
       .almost_full_host_wr_03(almost_full_host_wr_03),   // Input      status_host_wr_03[1]
       .almost_empty_host_rd_04(almost_empty_host_rd_04),  // Input     status_host_rd_04[0]
       .almost_full_host_rd_04(almost_full_host_rd_04),   // Input      status_host_rd_04[1]
       .almost_full_host_wr_04(almost_full_host_wr_04),   // Input      status_host_wr_04[1]
       .almost_empty_host_rd_05(almost_empty_host_rd_05),  // Input     status_host_rd_05[0]
       .almost_full_host_rd_05(almost_full_host_rd_05),   // Input      status_host_rd_05[1]
       .almost_full_host_wr_05(almost_full_host_wr_05),   // Input      status_host_wr_05[1]
       .almost_empty_host_rd_20(almost_empty_host_rd_20),  // Input     status_host_rd_20[0]
       .almost_full_host_rd_20(almost_full_host_rd_20),   // Input      status_host_rd_20[1]
       .almost_full_host_wr_20(almost_full_host_wr_20),   // Input      status_host_wr_20[1]
       .almost_empty_host_rd_21(almost_empty_host_rd_21),  // Input     status_host_rd_21[0]
       .almost_full_host_rd_21(almost_full_host_rd_21),   // Input      status_host_rd_21[1]
       .almost_full_host_wr_21(almost_full_host_wr_21),   // Input      status_host_wr_21[1]
        
       // Mode registers (Host->FPGA). Use to set hardware working modes
       .tc_ctrl(tc_ctrl[7:0]),                            // Output     ctrl[7..0]
       .mbvec_size(mbvec_size[15:0]),                     // Output     ctrl[23..8]
       .mbidx_rd_bound(mbidx_rd_bound[31:0]),             // Output
       .ma_rd_bound(ma_rd_bound[31:0]),                   // Output
       .buf_ld_sel(buf_ld_sel[31:0]),                     // Output
        
       // Select signals for user's memories / reggroups
       .sel_cross_bar_00_host_rd_00(sel_cross_bar_00_host_rd_00),  // Output select for cross_bar_00_host_rd_00
       .sel_start_cross_bar_00_host_rd_00(sel_start_cross_bar_00_host_rd_00),  // Output select for start_cross_bar_00_host_rd_00
       .sel_cross_bar_00_host_wr_00(sel_cross_bar_00_host_wr_00),  // Output select for cross_bar_00_host_wr_00
       .sel_start_cross_bar_00_host_wr_00(sel_start_cross_bar_00_host_wr_00),  // Output select for start_cross_bar_00_host_wr_00
       .sel_cross_bar_01_host_rd_01(sel_cross_bar_01_host_rd_01),  // Output select for cross_bar_01_host_rd_01
       .sel_start_cross_bar_01_host_rd_01(sel_start_cross_bar_01_host_rd_01),  // Output select for start_cross_bar_01_host_rd_01
       .sel_cross_bar_01_host_wr_01(sel_cross_bar_01_host_wr_01),  // Output select for cross_bar_01_host_wr_01
       .sel_start_cross_bar_01_host_wr_01(sel_start_cross_bar_01_host_wr_01),  // Output select for start_cross_bar_01_host_wr_01
       .sel_cross_bar_02_host_rd_02(sel_cross_bar_02_host_rd_02),  // Output select for cross_bar_02_host_rd_02
       .sel_start_cross_bar_02_host_rd_02(sel_start_cross_bar_02_host_rd_02),  // Output select for start_cross_bar_02_host_rd_02
       .sel_cross_bar_02_host_wr_02(sel_cross_bar_02_host_wr_02),  // Output select for cross_bar_02_host_wr_02
       .sel_start_cross_bar_02_host_wr_02(sel_start_cross_bar_02_host_wr_02),  // Output select for start_cross_bar_02_host_wr_02
       .sel_cross_bar_03_host_rd_03(sel_cross_bar_03_host_rd_03),  // Output select for cross_bar_03_host_rd_03
       .sel_start_cross_bar_03_host_rd_03(sel_start_cross_bar_03_host_rd_03),  // Output select for start_cross_bar_03_host_rd_03
       .sel_cross_bar_03_host_wr_03(sel_cross_bar_03_host_wr_03),  // Output select for cross_bar_03_host_wr_03
       .sel_start_cross_bar_03_host_wr_03(sel_start_cross_bar_03_host_wr_03),  // Output select for start_cross_bar_03_host_wr_03
       .sel_cross_bar_04_host_rd_04(sel_cross_bar_04_host_rd_04),  // Output select for cross_bar_04_host_rd_04
       .sel_start_cross_bar_04_host_rd_04(sel_start_cross_bar_04_host_rd_04),  // Output select for start_cross_bar_04_host_rd_04
       .sel_cross_bar_04_host_wr_04(sel_cross_bar_04_host_wr_04),  // Output select for cross_bar_04_host_wr_04
       .sel_start_cross_bar_04_host_wr_04(sel_start_cross_bar_04_host_wr_04),  // Output select for start_cross_bar_04_host_wr_04
       .sel_cross_bar_05_host_rd_05(sel_cross_bar_05_host_rd_05),  // Output select for cross_bar_05_host_rd_05
       .sel_start_cross_bar_05_host_rd_05(sel_start_cross_bar_05_host_rd_05),  // Output select for start_cross_bar_05_host_rd_05
       .sel_cross_bar_05_host_wr_05(sel_cross_bar_05_host_wr_05),  // Output select for cross_bar_05_host_wr_05
       .sel_start_cross_bar_05_host_wr_05(sel_start_cross_bar_05_host_wr_05),  // Output select for start_cross_bar_05_host_wr_05
       .sel_cross_bar_20_host_rd_20(sel_cross_bar_20_host_rd_20),  // Output select for cross_bar_20_host_rd_20
       .sel_start_cross_bar_20_host_rd_20(sel_start_cross_bar_20_host_rd_20),  // Output select for start_cross_bar_20_host_rd_20
       .sel_cross_bar_20_host_wr_20(sel_cross_bar_20_host_wr_20),  // Output select for cross_bar_20_host_wr_20
       .sel_start_cross_bar_20_host_wr_20(sel_start_cross_bar_20_host_wr_20),  // Output select for start_cross_bar_20_host_wr_20
       .sel_cross_bar_21_host_rd_21(sel_cross_bar_21_host_rd_21),  // Output select for cross_bar_21_host_rd_21
       .sel_start_cross_bar_21_host_rd_21(sel_start_cross_bar_21_host_rd_21),  // Output select for start_cross_bar_21_host_rd_21
       .sel_cross_bar_21_host_wr_21(sel_cross_bar_21_host_wr_21),  // Output select for cross_bar_21_host_wr_21
       .sel_start_cross_bar_21_host_wr_21(sel_start_cross_bar_21_host_wr_21),  // Output select for start_cross_bar_21_host_wr_21
       .g_dreq_wr({g_dreq_cross_bar_21_host_wr_21, g_dreq_cross_bar_20_host_wr_20, g_dreq_cross_bar_05_host_wr_05, g_dreq_cross_bar_04_host_wr_04, g_dreq_cross_bar_03_host_wr_03, g_dreq_cross_bar_02_host_wr_02, g_dreq_cross_bar_01_host_wr_01, g_dreq_cross_bar_00_host_wr_00}),  // Input
       .g_dreq_rd({g_dreq_cross_bar_21_host_rd_21, g_dreq_cross_bar_20_host_rd_20, g_dreq_cross_bar_05_host_rd_05, g_dreq_cross_bar_04_host_rd_04, g_dreq_cross_bar_03_host_rd_03, g_dreq_cross_bar_02_host_rd_02, g_dreq_cross_bar_01_host_rd_01, g_dreq_cross_bar_00_host_rd_00})   // Input
       );
   
   
   
  //======================================================================
  //=                   User's entities' connections                     =
  //======================================================================
  logic clrn_d1t, clrn_d2t;
  always_ff @(posedge clk or negedge clrn) begin
     if (!clrn) begin
          clrn_d1t <= 0;
          clrn_d2t <= 0;
     end else begin
          clrn_d1t <= 1;
          clrn_d2t <= clrn_d1t;
     end
  end
   
  tensor_core_array_wrapper  u1
  (
       .clrn(clrn_d2t),                                       // Input
       .clk(clk),                                         // Input
       .tc_ctrl(tc_ctrl),                                 // Input
       .mbvec_size(mbvec_size),                           // Input
       .mbidx_rd_bound(mbidx_rd_bound),                   // Input
       .ma_rd_bound(ma_rd_bound),                         // Input
       .buf_ld_sel(buf_ld_sel),                           // Input
       .lat_counter(lat_counter),                         // Output
       .err_info(err_info),                               // Output
       .hbm_0_ready(hbm_0_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_in_0(start_tcarray_in_0),           // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_in_0(select_tcarray_in_0),         // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataoutputs data on each port clock
       .data_tcarray_in_0(data_tcarray_in_0),             // Input      Data from port tcarray_in_0 of MultiPort cross_bar_00
       .addr_tcarray_in_0(addr_tcarray_in_0),             // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_empty_tcarray_in_0(almost_empty_tcarray_in_0),  // Input Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_0(port_error_tcarray_in_0),  // Input     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_1_ready(hbm_1_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_in_1(start_tcarray_in_1),           // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_in_1(select_tcarray_in_1),         // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataoutputs data on each port clock
       .data_tcarray_in_1(data_tcarray_in_1),             // Input      Data from port tcarray_in_1 of MultiPort cross_bar_01
       .addr_tcarray_in_1(addr_tcarray_in_1),             // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_empty_tcarray_in_1(almost_empty_tcarray_in_1),  // Input Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_1(port_error_tcarray_in_1),  // Input     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_2_ready(hbm_2_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_in_2(start_tcarray_in_2),           // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_in_2(select_tcarray_in_2),         // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataoutputs data on each port clock
       .data_tcarray_in_2(data_tcarray_in_2),             // Input      Data from port tcarray_in_2 of MultiPort cross_bar_02
       .addr_tcarray_in_2(addr_tcarray_in_2),             // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_empty_tcarray_in_2(almost_empty_tcarray_in_2),  // Input Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_2(port_error_tcarray_in_2),  // Input     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_3_ready(hbm_3_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_in_3(start_tcarray_in_3),           // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_in_3(select_tcarray_in_3),         // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataoutputs data on each port clock
       .data_tcarray_in_3(data_tcarray_in_3),             // Input      Data from port tcarray_in_3 of MultiPort cross_bar_03
       .addr_tcarray_in_3(addr_tcarray_in_3),             // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_empty_tcarray_in_3(almost_empty_tcarray_in_3),  // Input Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_3(port_error_tcarray_in_3),  // Input     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_4_ready(hbm_4_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_in_4(start_tcarray_in_4),           // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_in_4(select_tcarray_in_4),         // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataoutputs data on each port clock
       .data_tcarray_in_4(data_tcarray_in_4),             // Input      Data from port tcarray_in_4 of MultiPort cross_bar_04
       .addr_tcarray_in_4(addr_tcarray_in_4),             // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_empty_tcarray_in_4(almost_empty_tcarray_in_4),  // Input Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_4(port_error_tcarray_in_4),  // Input     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_5_ready(hbm_5_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_in_5(start_tcarray_in_5),           // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_in_5(select_tcarray_in_5),         // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataoutputs data on each port clock
       .data_tcarray_in_5(data_tcarray_in_5),             // Input      Data from port tcarray_in_5 of MultiPort cross_bar_05
       .addr_tcarray_in_5(addr_tcarray_in_5),             // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_empty_tcarray_in_5(almost_empty_tcarray_in_5),  // Input Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_5(port_error_tcarray_in_5),  // Input     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_6_ready(hbm_6_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_out_0(start_tcarray_out_0),         // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_out_0(select_tcarray_out_0),       // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataexpects data on each port clock
       .data_tcarray_out_0(data_tcarray_out_0),           // Output     Data to port tcarray_out_0 of MultiPort cross_bar_20
       .addr_tcarray_out_0(addr_tcarray_out_0),           // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_full_tcarray_out_0(almost_full_tcarray_out_0),  // Input Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_tcarray_out_0(port_error_tcarray_out_0),  // Input   Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .hbm_7_ready(hbm_7_ready),                         // Input      1: Memory controller is ready for use, 0: Initializing (due to reset)
       .start_tcarray_out_1(start_tcarray_out_1),         // Output     Port start signal. Assert high for 1 port clk + 1 mem clk to reset the port
       .select_tcarray_out_1(select_tcarray_out_1),       // Output     Port select (enable) signal. Should be high until ready comes to transfer current dataexpects data on each port clock
       .data_tcarray_out_1(data_tcarray_out_1),           // Output     Data to port tcarray_out_1 of MultiPort cross_bar_21
       .addr_tcarray_out_1(addr_tcarray_out_1),           // Output     Port starting address. Apply the new address to this bus when reseting the port (start=VCC)
       .almost_full_tcarray_out_1(almost_full_tcarray_out_1),  // Input Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_tcarray_out_1(port_error_tcarray_out_1)   // Input   Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       );
   
   
   
   
  //======================================================================
  //=                  Reserved entities' connections                    =
  //======================================================================
   
   
   
  // g_firmware connections
   
  g_s10firmware  u2
  (
        
       // Gidel Firmware inputs
       .ref_clk(clk_125m),                                // Input
       .hbm_clk_top(hbm_clk_top),                         // Input
       .clrn(clrn),                                       // Input
       .g_freserved_i(g_reserved_o[99:0]),                // Input
       .g_freserved_o(g_freserved_o[4:0]),                // Output
       .hbm_o(hbm_o),                                     // Input
        
        
       // Gidel Firmware outputs
       .hbm_i(hbm_i),                                     // Output
        
        
       // HBM TOP connection
       .cattrip_top(cattrip_top),                         // Input
       .temp_top(temp_top[2:0]),                          // Input
       .wso_top(wso_top[7:0])                             // Input
       );
   
   
   
   
  //======================================================================
  //=                   SDRAM controllers' connections                   =
  //======================================================================
   
  //======================================================================
  //=                         IC_1_Bank_0_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_0_Ctrl  u3
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_0_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[0]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[0]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_in_0 Connections
       .clk_tcarray_in_0(clk),                            // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_in_0(start_tcarray_in_0),           // Input      Port start (reset) signal
       .select_tcarray_in_0(select_tcarray_in_0),         // Input      Port select (enable) signal
       .data_tcarray_in_0(data_tcarray_in_0[255:0]),      // Output     Data from port tcarray_in_0 of MultiPort cross_bar_00
       .addr_tcarray_in_0(addr_tcarray_in_0[31:0]),       // Input      Port address input
       .almost_empty_tcarray_in_0(almost_empty_tcarray_in_0),  // Output Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_0(port_error_tcarray_in_0),  // Output    Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_00 Connections
       .clk_host_rd_00(lclk),                             // Input      Port clock
       .start_host_rd_00(sel_start_cross_bar_00_host_rd_00),  // Input  Port start (reset) signal
       .select_host_rd_00(sel_cross_bar_00_host_rd_00),   // Input      Port select (enable) signal
       .data_host_rd_00(data_host_rd_00[255:0]),          // Output     Data from port host_rd_00 of MultiPort cross_bar_00
       .almost_empty_host_rd_00(almost_empty_host_rd_00),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_00(almost_full_host_rd_00),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_00(port_error_host_rd_00),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_00_host_rd_00(g_dreq_cross_bar_00_host_rd_00),  // Output DMA transfer hold request from the port
        
       // Port host_wr_00 Connections
       .clk_host_wr_00(lclk),                             // Input      Port clock
       .start_host_wr_00(sel_start_cross_bar_00_host_wr_00),  // Input  Port start (reset) signal
       .select_host_wr_00(sel_cross_bar_00_host_wr_00),   // Input      Port select (enable) signal
       .data_host_wr_00(l_data_wr[255:0]),                // Input      Data to port host_wr_00 of MultiPort cross_bar_00
       .almost_full_host_wr_00(almost_full_host_wr_00),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_00(port_error_host_wr_00),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_00_host_wr_00(g_dreq_cross_bar_00_host_wr_00)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_1_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_1_Ctrl  u4
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_1_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[1]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[1]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_in_1 Connections
       .clk_tcarray_in_1(clk),                            // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_in_1(start_tcarray_in_1),           // Input      Port start (reset) signal
       .select_tcarray_in_1(select_tcarray_in_1),         // Input      Port select (enable) signal
       .data_tcarray_in_1(data_tcarray_in_1[255:0]),      // Output     Data from port tcarray_in_1 of MultiPort cross_bar_01
       .addr_tcarray_in_1(addr_tcarray_in_1[31:0]),       // Input      Port address input
       .almost_empty_tcarray_in_1(almost_empty_tcarray_in_1),  // Output Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_1(port_error_tcarray_in_1),  // Output    Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_01 Connections
       .clk_host_rd_01(lclk),                             // Input      Port clock
       .start_host_rd_01(sel_start_cross_bar_01_host_rd_01),  // Input  Port start (reset) signal
       .select_host_rd_01(sel_cross_bar_01_host_rd_01),   // Input      Port select (enable) signal
       .data_host_rd_01(data_host_rd_01[255:0]),          // Output     Data from port host_rd_01 of MultiPort cross_bar_01
       .almost_empty_host_rd_01(almost_empty_host_rd_01),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_01(almost_full_host_rd_01),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_01(port_error_host_rd_01),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_01_host_rd_01(g_dreq_cross_bar_01_host_rd_01),  // Output DMA transfer hold request from the port
        
       // Port host_wr_01 Connections
       .clk_host_wr_01(lclk),                             // Input      Port clock
       .start_host_wr_01(sel_start_cross_bar_01_host_wr_01),  // Input  Port start (reset) signal
       .select_host_wr_01(sel_cross_bar_01_host_wr_01),   // Input      Port select (enable) signal
       .data_host_wr_01(l_data_wr[255:0]),                // Input      Data to port host_wr_01 of MultiPort cross_bar_01
       .almost_full_host_wr_01(almost_full_host_wr_01),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_01(port_error_host_wr_01),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_01_host_wr_01(g_dreq_cross_bar_01_host_wr_01)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_2_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_2_Ctrl  u5
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_2_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[2]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[2]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_in_2 Connections
       .clk_tcarray_in_2(clk),                            // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_in_2(start_tcarray_in_2),           // Input      Port start (reset) signal
       .select_tcarray_in_2(select_tcarray_in_2),         // Input      Port select (enable) signal
       .data_tcarray_in_2(data_tcarray_in_2[255:0]),      // Output     Data from port tcarray_in_2 of MultiPort cross_bar_02
       .addr_tcarray_in_2(addr_tcarray_in_2[31:0]),       // Input      Port address input
       .almost_empty_tcarray_in_2(almost_empty_tcarray_in_2),  // Output Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_2(port_error_tcarray_in_2),  // Output    Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_02 Connections
       .clk_host_rd_02(lclk),                             // Input      Port clock
       .start_host_rd_02(sel_start_cross_bar_02_host_rd_02),  // Input  Port start (reset) signal
       .select_host_rd_02(sel_cross_bar_02_host_rd_02),   // Input      Port select (enable) signal
       .data_host_rd_02(data_host_rd_02[255:0]),          // Output     Data from port host_rd_02 of MultiPort cross_bar_02
       .almost_empty_host_rd_02(almost_empty_host_rd_02),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_02(almost_full_host_rd_02),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_02(port_error_host_rd_02),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_02_host_rd_02(g_dreq_cross_bar_02_host_rd_02),  // Output DMA transfer hold request from the port
        
       // Port host_wr_02 Connections
       .clk_host_wr_02(lclk),                             // Input      Port clock
       .start_host_wr_02(sel_start_cross_bar_02_host_wr_02),  // Input  Port start (reset) signal
       .select_host_wr_02(sel_cross_bar_02_host_wr_02),   // Input      Port select (enable) signal
       .data_host_wr_02(l_data_wr[255:0]),                // Input      Data to port host_wr_02 of MultiPort cross_bar_02
       .almost_full_host_wr_02(almost_full_host_wr_02),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_02(port_error_host_wr_02),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_02_host_wr_02(g_dreq_cross_bar_02_host_wr_02)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_3_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_3_Ctrl  u6
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_3_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[3]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[3]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_in_3 Connections
       .clk_tcarray_in_3(clk),                            // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_in_3(start_tcarray_in_3),           // Input      Port start (reset) signal
       .select_tcarray_in_3(select_tcarray_in_3),         // Input      Port select (enable) signal
       .data_tcarray_in_3(data_tcarray_in_3[255:0]),      // Output     Data from port tcarray_in_3 of MultiPort cross_bar_03
       .addr_tcarray_in_3(addr_tcarray_in_3[31:0]),       // Input      Port address input
       .almost_empty_tcarray_in_3(almost_empty_tcarray_in_3),  // Output Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_3(port_error_tcarray_in_3),  // Output    Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_03 Connections
       .clk_host_rd_03(lclk),                             // Input      Port clock
       .start_host_rd_03(sel_start_cross_bar_03_host_rd_03),  // Input  Port start (reset) signal
       .select_host_rd_03(sel_cross_bar_03_host_rd_03),   // Input      Port select (enable) signal
       .data_host_rd_03(data_host_rd_03[255:0]),          // Output     Data from port host_rd_03 of MultiPort cross_bar_03
       .almost_empty_host_rd_03(almost_empty_host_rd_03),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_03(almost_full_host_rd_03),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_03(port_error_host_rd_03),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_03_host_rd_03(g_dreq_cross_bar_03_host_rd_03),  // Output DMA transfer hold request from the port
        
       // Port host_wr_03 Connections
       .clk_host_wr_03(lclk),                             // Input      Port clock
       .start_host_wr_03(sel_start_cross_bar_03_host_wr_03),  // Input  Port start (reset) signal
       .select_host_wr_03(sel_cross_bar_03_host_wr_03),   // Input      Port select (enable) signal
       .data_host_wr_03(l_data_wr[255:0]),                // Input      Data to port host_wr_03 of MultiPort cross_bar_03
       .almost_full_host_wr_03(almost_full_host_wr_03),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_03(port_error_host_wr_03),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_03_host_wr_03(g_dreq_cross_bar_03_host_wr_03)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_4_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_4_Ctrl  u7
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_4_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[4]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[4]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_in_4 Connections
       .clk_tcarray_in_4(clk),                            // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_in_4(start_tcarray_in_4),           // Input      Port start (reset) signal
       .select_tcarray_in_4(select_tcarray_in_4),         // Input      Port select (enable) signal
       .data_tcarray_in_4(data_tcarray_in_4[255:0]),      // Output     Data from port tcarray_in_4 of MultiPort cross_bar_04
       .addr_tcarray_in_4(addr_tcarray_in_4[31:0]),       // Input      Port address input
       .almost_empty_tcarray_in_4(almost_empty_tcarray_in_4),  // Output Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_4(port_error_tcarray_in_4),  // Output    Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_04 Connections
       .clk_host_rd_04(lclk),                             // Input      Port clock
       .start_host_rd_04(sel_start_cross_bar_04_host_rd_04),  // Input  Port start (reset) signal
       .select_host_rd_04(sel_cross_bar_04_host_rd_04),   // Input      Port select (enable) signal
       .data_host_rd_04(data_host_rd_04[255:0]),          // Output     Data from port host_rd_04 of MultiPort cross_bar_04
       .almost_empty_host_rd_04(almost_empty_host_rd_04),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_04(almost_full_host_rd_04),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_04(port_error_host_rd_04),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_04_host_rd_04(g_dreq_cross_bar_04_host_rd_04),  // Output DMA transfer hold request from the port
        
       // Port host_wr_04 Connections
       .clk_host_wr_04(lclk),                             // Input      Port clock
       .start_host_wr_04(sel_start_cross_bar_04_host_wr_04),  // Input  Port start (reset) signal
       .select_host_wr_04(sel_cross_bar_04_host_wr_04),   // Input      Port select (enable) signal
       .data_host_wr_04(l_data_wr[255:0]),                // Input      Data to port host_wr_04 of MultiPort cross_bar_04
       .almost_full_host_wr_04(almost_full_host_wr_04),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_04(port_error_host_wr_04),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_04_host_wr_04(g_dreq_cross_bar_04_host_wr_04)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_5_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_5_Ctrl  u8
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_5_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[5]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[5]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_in_5 Connections
       .clk_tcarray_in_5(clk),                            // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_in_5(start_tcarray_in_5),           // Input      Port start (reset) signal
       .select_tcarray_in_5(select_tcarray_in_5),         // Input      Port select (enable) signal
       .data_tcarray_in_5(data_tcarray_in_5[255:0]),      // Output     Data from port tcarray_in_5 of MultiPort cross_bar_05
       .addr_tcarray_in_5(addr_tcarray_in_5[31:0]),       // Input      Port address input
       .almost_empty_tcarray_in_5(almost_empty_tcarray_in_5),  // Output Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .port_error_tcarray_in_5(port_error_tcarray_in_5),  // Output    Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_05 Connections
       .clk_host_rd_05(lclk),                             // Input      Port clock
       .start_host_rd_05(sel_start_cross_bar_05_host_rd_05),  // Input  Port start (reset) signal
       .select_host_rd_05(sel_cross_bar_05_host_rd_05),   // Input      Port select (enable) signal
       .data_host_rd_05(data_host_rd_05[255:0]),          // Output     Data from port host_rd_05 of MultiPort cross_bar_05
       .almost_empty_host_rd_05(almost_empty_host_rd_05),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_05(almost_full_host_rd_05),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_05(port_error_host_rd_05),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_05_host_rd_05(g_dreq_cross_bar_05_host_rd_05),  // Output DMA transfer hold request from the port
        
       // Port host_wr_05 Connections
       .clk_host_wr_05(lclk),                             // Input      Port clock
       .start_host_wr_05(sel_start_cross_bar_05_host_wr_05),  // Input  Port start (reset) signal
       .select_host_wr_05(sel_cross_bar_05_host_wr_05),   // Input      Port select (enable) signal
       .data_host_wr_05(l_data_wr[255:0]),                // Input      Data to port host_wr_05 of MultiPort cross_bar_05
       .almost_full_host_wr_05(almost_full_host_wr_05),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_05(port_error_host_wr_05),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_05_host_wr_05(g_dreq_cross_bar_05_host_wr_05)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_6_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_6_Ctrl  u9
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_6_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[6]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[6]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_out_0 Connections
       .clk_tcarray_out_0(clk),                           // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_out_0(start_tcarray_out_0),         // Input      Port start (reset) signal
       .select_tcarray_out_0(select_tcarray_out_0),       // Input      Port select (enable) signal
       .data_tcarray_out_0(data_tcarray_out_0[255:0]),    // Input      Data to port tcarray_out_0 of MultiPort cross_bar_20
       .addr_tcarray_out_0(addr_tcarray_out_0[31:0]),     // Input      Port address input
       .almost_full_tcarray_out_0(almost_full_tcarray_out_0),  // Output Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_tcarray_out_0(port_error_tcarray_out_0),  // Output  Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_20 Connections
       .clk_host_rd_20(lclk),                             // Input      Port clock
       .start_host_rd_20(sel_start_cross_bar_20_host_rd_20),  // Input  Port start (reset) signal
       .select_host_rd_20(sel_cross_bar_20_host_rd_20),   // Input      Port select (enable) signal
       .data_host_rd_20(data_host_rd_20[255:0]),          // Output     Data from port host_rd_20 of MultiPort cross_bar_20
       .almost_empty_host_rd_20(almost_empty_host_rd_20),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_20(almost_full_host_rd_20),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_20(port_error_host_rd_20),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_20_host_rd_20(g_dreq_cross_bar_20_host_rd_20),  // Output DMA transfer hold request from the port
        
       // Port host_wr_20 Connections
       .clk_host_wr_20(lclk),                             // Input      Port clock
       .start_host_wr_20(sel_start_cross_bar_20_host_wr_20),  // Input  Port start (reset) signal
       .select_host_wr_20(sel_cross_bar_20_host_wr_20),   // Input      Port select (enable) signal
       .data_host_wr_20(l_data_wr[255:0]),                // Input      Data to port host_wr_20 of MultiPort cross_bar_20
       .almost_full_host_wr_20(almost_full_host_wr_20),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_20(port_error_host_wr_20),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_20_host_wr_20(g_dreq_cross_bar_20_host_wr_20)   // Output DMA transfer hold request from the port
       );
   
   
  //======================================================================
  //=                         IC_1_Bank_7_Ctrl                           =
  //======================================================================
   
   
  IC_1_Bank_7_Ctrl  u10
  (
       // Global MultiPort Connections
       .clrn(clrn),                                       // Input      MultiPort async global reset
       .g_reserved_control(g_reserved_control[99:0]),     // Input      SDRAM Connection
       .ready(hbm_7_ready),                               // Output     1: Memory controller is ready for use, 0: Initializing (due to reset)
       .dram_i(hbm_i[7]),                                 // Output     Inputs  from external EMIF module
       .dram_o(hbm_o[7]),                                 // Output     Outputs to external EMIF module
        
       // Port tcarray_out_1 Connections
       .clk_tcarray_out_1(clk),                           // Input      Clock: clk  ( 240.00 MHz )
       .start_tcarray_out_1(start_tcarray_out_1),         // Input      Port start (reset) signal
       .select_tcarray_out_1(select_tcarray_out_1),       // Input      Port select (enable) signal
       .data_tcarray_out_1(data_tcarray_out_1[255:0]),    // Input      Data to port tcarray_out_1 of MultiPort cross_bar_21
       .addr_tcarray_out_1(addr_tcarray_out_1[31:0]),     // Input      Port address input
       .almost_full_tcarray_out_1(almost_full_tcarray_out_1),  // Output Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_tcarray_out_1(port_error_tcarray_out_1),  // Output  Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
        
       // Port host_rd_21 Connections
       .clk_host_rd_21(lclk),                             // Input      Port clock
       .start_host_rd_21(sel_start_cross_bar_21_host_rd_21),  // Input  Port start (reset) signal
       .select_host_rd_21(sel_cross_bar_21_host_rd_21),   // Input      Port select (enable) signal
       .data_host_rd_21(data_host_rd_21[255:0]),          // Output     Data from port host_rd_21 of MultiPort cross_bar_21
       .almost_empty_host_rd_21(almost_empty_host_rd_21),  // Output    Port almost_empty flag (goes low when the internal FIFO more than 1/8 full)
       .almost_full_host_rd_21(almost_full_host_rd_21),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_rd_21(port_error_host_rd_21),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_21_host_rd_21(g_dreq_cross_bar_21_host_rd_21),  // Output DMA transfer hold request from the port
        
       // Port host_wr_21 Connections
       .clk_host_wr_21(lclk),                             // Input      Port clock
       .start_host_wr_21(sel_start_cross_bar_21_host_wr_21),  // Input  Port start (reset) signal
       .select_host_wr_21(sel_cross_bar_21_host_wr_21),   // Input      Port select (enable) signal
       .data_host_wr_21(l_data_wr[255:0]),                // Input      Data to port host_wr_21 of MultiPort cross_bar_21
       .almost_full_host_wr_21(almost_full_host_wr_21),   // Output     Port almost_full flag (goes high when the internal FIFO more than 7/8 full)
       .port_error_host_wr_21(port_error_host_wr_21),     // Output     Port port_error flag (goes high when an error occur to port (read from empty FIFO or write to full FIFO)
       .g_dreq_cross_bar_21_host_wr_21(g_dreq_cross_bar_21_host_wr_21)   // Output DMA transfer hold request from the port
       );
   
   
  assign  rbf_version[7:0] =  RBF_VERSION_VAL;  
  assign  build_version[7:0] =  BUILD_VERSION_VAL;  
  //======================================================================
  //=                Default Values of Board Connections                 =
  //======================================================================
   
  // User's buses
   
  assign  mem_ready_wr  = 1'h1;                          // '1'   NO WAIT STATES, put '0' when you want to add wait states
   
  assign  mem_ready_rd  = 1'h1;                          // '1'   NO WAIT STATES, put '0' when you want to add wait states
  assign  l_data_rd[31:0] = sel_cross_bar_00_host_rd_00 == 1'b1 ? data_host_rd_00[31:0]:
                           sel_cross_bar_01_host_rd_01 == 1'b1 ? data_host_rd_01[31:0] : 
                           sel_cross_bar_02_host_rd_02 == 1'b1 ? data_host_rd_02[31:0] : 
                           sel_cross_bar_03_host_rd_03 == 1'b1 ? data_host_rd_03[31:0] : 
                           sel_cross_bar_04_host_rd_04 == 1'b1 ? data_host_rd_04[31:0] : 
                           sel_cross_bar_05_host_rd_05 == 1'b1 ? data_host_rd_05[31:0] : 
                           sel_cross_bar_20_host_rd_20 == 1'b1 ? data_host_rd_20[31:0] : 
                           sel_cross_bar_21_host_rd_21 == 1'b1 ? data_host_rd_21[31:0] : 32'b0;
   
  assign  l_data_rd[255:32] = sel_cross_bar_00_host_rd_00 == 1'b1 ? data_host_rd_00[255:32]:
                           sel_cross_bar_01_host_rd_01 == 1'b1 ? data_host_rd_01[255:32] : 
                           sel_cross_bar_02_host_rd_02 == 1'b1 ? data_host_rd_02[255:32] : 
                           sel_cross_bar_03_host_rd_03 == 1'b1 ? data_host_rd_03[255:32] : 
                           sel_cross_bar_04_host_rd_04 == 1'b1 ? data_host_rd_04[255:32] : 
                           sel_cross_bar_05_host_rd_05 == 1'b1 ? data_host_rd_05[255:32] : 
                           sel_cross_bar_20_host_rd_20 == 1'b1 ? data_host_rd_20[255:32] : 
                           sel_cross_bar_21_host_rd_21 == 1'b1 ? data_host_rd_21[255:32] : 224'b0;
   
  assign  interrupt  = 1'h1;                             // Interrupt control - assert low to send interrupt to SoftWare, when interrupt_ack is high.
  assign  user_dreq  = 32'h0;                            // DMA control - assert low to enable DMA operation, high to stop DMA (for each DMA channel).
  assign  user_flush_rd  = 1'h0;
  assign  last_size_rd  = 5'h0;
  assign  act_led_greenn  = 2'hz;
  assign  act_led_redn  = 2'hz;
  assign  act_led_1c_greenn  = 2'hz;
  assign  act_led_1c_redn  = 2'hz;
  assign  status_ledno[0]  = 1'h0;
  assign  status_ledno[1]       =  status_ledn[1];  
  assign  status_1C_ledo        =  status_ledn[0];  
  assign  clk2pll  = 2'h0;
   
  // External connector I/O's
  assign  ext_io   = 12'hz;
  assign  lvttl_io  = 1'hz;
  assign  J13_hv_drv_o  = 2'h3;
   
  // Gidel reserved status bus. Please do not change.
  assign  g_reserved_status[0]  = 1'h1;
  assign  g_reserved_status[1]  = 1'h1;
  assign  g_reserved_status[2]  = 1'h1;
  assign  g_reserved_status[3]  = 1'h1;
  assign  g_reserved_status[4]  = 1'h1;
  assign  g_reserved_status[5]  = 1'h1;
  assign  g_reserved_status[6]  = 1'h1;
  assign  g_reserved_status[7]  = 1'h0;
  assign  g_reserved_status[13:8]  = 6'h0;
  assign  g_reserved_status[99:14]  = 86'h0;
  assign  g_reserved_i[17:0]        = g_reservedi[17:0];  
  assign  g_reserved_i[18]  = 1'h0;
  assign  g_reserved_i[23:19]       = g_freserved_o[4:0];  
  assign  g_reserved_i[26:24]       = Cid[2:0];  
  assign  g_reserved_i[27]          = T_prsntL;  
  assign  g_reserved_i[29:28]       = T_id[1:0];  
  assign  g_reserved_i[30]          = L_prsntL;  
  assign  g_reserved_i[31]          = L_id;  
  assign  g_reserved_i[99:32]  = 68'h0;
  assign  g_reservedo[7:1]          = g_reserved_o[7:1];  
  assign  clk0_vpin                 = clk0;  
  assign  clk_vpin                  = clk;  
  assign  clk2_vpin                 = clk2;  
   
   
 endmodule
