//**************************************************************************************************************************************************************
//  Gidel Copyright (C) 1993-2025                                                                                                                             
//  HDL ic_tcorearray_if was generated by Gidel ProcWizard Application version 9.8.7.3                                                                        
//  ic_tcorearray_if is the bus interface for ****  device (IC) 1 ****                                                                                        
//  This file was generated for PROC configuration file  :"C:\Users\tianchu.ji\Documents\block_sparse_test\tensor_core_array_proj_mem.pcaf".                  
//  This file may only be used for initialization and usage of Gidel PROC boards.                                                                             
//  Using this file, or any other related files, for any other purpose, is prohibited .                                                                       
//  No other licenses are provided herein.                                                                                                                    
//  Created  Fri Mar 21 17:56:29 2025                                                                                                                         
//*************************************************************************************************************************************************************

`include    "g_functions.i"

     module  ic_tcorearray_if
     #(
          parameter        GDREQ_WR_NUM                 =  'h 8,
          parameter        GDREQ_RD_NUM                 =  'h 8,
          parameter        CONSUMER_COUNT               =  'h 20,
          parameter        PCIE_LANE_NUM                =  'h 10,
          parameter        BUS_WIDTH                    =  'h 100
     )
     (
          //============================================
          //=             Fixed connection             =
          //============================================
          input wire               ref_clk,       // ref_clk
          output wire              clk0,          // clk0
          output wire              clk,           // clk
          output wire              clk2,          // clk2
          inout wire               scl,           // scl
          inout wire               sda,           // sda
          output wire     [1:0]    status_ledn,   // status_ledn
          inout wire      [2:0]    g_reserved,    // g_reserved
          input wire      [99:0]   g_reserved_i,  // Gidel reserved Input bus
          output wire     [99:0]   g_reserved_o,  // Gidel reserved OUTPUT bus
          output wire              clrn,          // Reset input (active LOW)
          output wire              lclk,          // Local clock
          input wire      [CONSUMER_COUNT-1:0]   user_dreq,
          input wire      [GDREQ_WR_NUM-1:0]    g_dreq_wr,
          input wire      [GDREQ_RD_NUM-1:0]    g_dreq_rd,
          input wire               interrupt,
          output wire              interrupt_ack,
          input wire               user_flush_rd,
          input wire      [clog2(BUS_WIDTH/8)-1:0]    last_size_rd,
          output wire              l_eos,
          output wire     [(BUS_WIDTH/8)-1:0]    l_be,
          //============================================
          //=              Receiver I/O's              =
          //============================================
          output wire     [99:0]   g_reserved_control, //  
          input wire      [99:0]   g_reserved_status, //  
          output wire     [2:0]    id,            //  
          input wire               pcie_refclk,   // pcie_refclk
          input wire               pcie_perst,    // pcie_perst
          input wire      [PCIE_LANE_NUM-1:0]    pcie_rx,       // pcie_rx
          output wire     [PCIE_LANE_NUM-1:0]    pcie_tx,       // pcie_tx
          //============================================
          //=               WR IF I/O's                =
          //============================================
          output wire              l_wr,
          output wire     [31:0]   addr_wr,
          output wire     [31:0]   addr_rd,
          output wire     [BUS_WIDTH-1:0]  l_data_wr,
          input wire      [BUS_WIDTH-1:0]  l_data_rd,
          output wire              l_rd,
          input wire               mem_ready_wr,
          //============================================
          //=               RD IF I/O's                =
          //============================================
          input wire               mem_ready_rd,
          //============================================
          //=  Output from the logic to the host (status registers)  =
          //============================================
          input reg       [31:0]   lat_counter,
          input reg       [31:0]   err_info,
          // version of RBF
          input reg       [7:0]    rbf_version,   // RBF_Info[7:0]
          input reg       [7:0]    build_version, // RBF_Info[15:8]
          input reg                almost_empty_host_rd_00, // status_host_rd_00[0]
          input reg                almost_full_host_rd_00, // status_host_rd_00[1]
          input reg                almost_full_host_wr_00, // status_host_wr_00[1]
          input reg                almost_empty_host_rd_01, // status_host_rd_01[0]
          input reg                almost_full_host_rd_01, // status_host_rd_01[1]
          input reg                almost_full_host_wr_01, // status_host_wr_01[1]
          input reg                almost_empty_host_rd_02, // status_host_rd_02[0]
          input reg                almost_full_host_rd_02, // status_host_rd_02[1]
          input reg                almost_full_host_wr_02, // status_host_wr_02[1]
          input reg                almost_empty_host_rd_03, // status_host_rd_03[0]
          input reg                almost_full_host_rd_03, // status_host_rd_03[1]
          input reg                almost_full_host_wr_03, // status_host_wr_03[1]
          input reg                almost_empty_host_rd_04, // status_host_rd_04[0]
          input reg                almost_full_host_rd_04, // status_host_rd_04[1]
          input reg                almost_full_host_wr_04, // status_host_wr_04[1]
          input reg                almost_empty_host_rd_05, // status_host_rd_05[0]
          input reg                almost_full_host_rd_05, // status_host_rd_05[1]
          input reg                almost_full_host_wr_05, // status_host_wr_05[1]
          input reg                almost_empty_host_rd_20, // status_host_rd_20[0]
          input reg                almost_full_host_rd_20, // status_host_rd_20[1]
          input reg                almost_full_host_wr_20, // status_host_wr_20[1]
          input reg                almost_empty_host_rd_21, // status_host_rd_21[0]
          input reg                almost_full_host_rd_21, // status_host_rd_21[1]
          input reg                almost_full_host_wr_21, // status_host_wr_21[1]
          //============================================
          //=  Input from the host to the logic (mode registers)  =
          //============================================
          output reg      [7:0]    tc_ctrl,       // ctrl[7:0]
          output reg      [15:0]   mbvec_size,    // ctrl[23:8]
          output reg      [31:0]   mbidx_rd_bound,
          output reg      [31:0]   ma_rd_bound,
          output reg      [31:0]   buf_ld_sel,
          //============================================
          //=  Selectors to all memory address spaces  =
          //============================================
          output wire              sel_cross_bar_00_host_rd_00,
          output wire              sel_start_cross_bar_00_host_rd_00,
          output wire              sel_cross_bar_00_host_wr_00,
          output wire              sel_start_cross_bar_00_host_wr_00,
          output wire              sel_cross_bar_01_host_rd_01,
          output wire              sel_start_cross_bar_01_host_rd_01,
          output wire              sel_cross_bar_01_host_wr_01,
          output wire              sel_start_cross_bar_01_host_wr_01,
          output wire              sel_cross_bar_02_host_rd_02,
          output wire              sel_start_cross_bar_02_host_rd_02,
          output wire              sel_cross_bar_02_host_wr_02,
          output wire              sel_start_cross_bar_02_host_wr_02,
          output wire              sel_cross_bar_03_host_rd_03,
          output wire              sel_start_cross_bar_03_host_rd_03,
          output wire              sel_cross_bar_03_host_wr_03,
          output wire              sel_start_cross_bar_03_host_wr_03,
          output wire              sel_cross_bar_04_host_rd_04,
          output wire              sel_start_cross_bar_04_host_rd_04,
          output wire              sel_cross_bar_04_host_wr_04,
          output wire              sel_start_cross_bar_04_host_wr_04,
          output wire              sel_cross_bar_05_host_rd_05,
          output wire              sel_start_cross_bar_05_host_rd_05,
          output wire              sel_cross_bar_05_host_wr_05,
          output wire              sel_start_cross_bar_05_host_wr_05,
          output wire              sel_cross_bar_20_host_rd_20,
          output wire              sel_start_cross_bar_20_host_rd_20,
          output wire              sel_cross_bar_20_host_wr_20,
          output wire              sel_start_cross_bar_20_host_wr_20,
          output wire              sel_cross_bar_21_host_rd_21,
          output wire              sel_start_cross_bar_21_host_rd_21,
          output wire              sel_cross_bar_21_host_wr_21,
          output wire              sel_start_cross_bar_21_host_wr_21 
     );



        wire    [33:0]           unused_wires;
        wire                     clk_w;
        wire                     ads_w;
        wire                     ready_w;
        wire    [BUS_WIDTH-1:0]  ad_o_w;
        wire                     lw_r_w;
        wire                     blast_w;
        wire                     wait_l_w;
        wire                     time_out_w;


        wire                     clk_r;
        wire                     ads_r;
        wire                     ready_r;
        wire    [BUS_WIDTH-1:0]  ad_i_r;
        wire    [BUS_WIDTH-1:0]  ad_o_r;
        wire                     lw_r_r;
        wire                     blast_r;
        wire                     wait_l_r;
        wire                     time_out_r;


        assign  lclk                         = clk_w;


       g_avalon2if  #(
       .CONSUMER_COUNT(CONSUMER_COUNT),
       .USER_ITRP_NUM(1),
       .GDREQ_WR_NUM(GDREQ_WR_NUM),
       .GDREQ_RD_NUM(GDREQ_RD_NUM),
       .BUS_WIDTH(BUS_WIDTH),
       .PCIE_LANE_NUM(PCIE_LANE_NUM),
       .LBUS_FREQUENCY(150) 
       ) g_pcielb2if_cmp (
   
       .g_reserved_control(g_reserved_control),
       .g_reserved_status(g_reserved_status),
       .id0(id[0]),
       .id1(id[1]),
       .id2(id[2]),
       .ref_clk(ref_clk),
       .clk0(clk0),
       .clk(clk),
       .clk2(clk2),
       .clrn(clrn),
       .scl(scl),
       .sda(sda),
       .g_reserved_i(g_reserved_i),
       .g_reserved_o(g_reserved_o),
       .g_reserved({unused_wires[33:3],g_reserved[2:0]}),
       .status_ledn({unused_wires[2],status_ledn}),
       .pcie_refclk(pcie_refclk),
       .pcie_perst(pcie_perst),
       .pcie_rx(pcie_rx),
       .pcie_tx(pcie_tx),
       .g_dreq_wr({1'b0, g_dreq_wr}),
       .g_dreq_rd({1'b0, g_dreq_rd}),
       .user_dreq(user_dreq),
       .interrupt(interrupt),
       .interrupt_ack(interrupt_ack),
       .user_flush_rd(user_flush_rd),
       .last_size_rd(last_size_rd),
       .eos(l_eos),
       .be(l_be),
       .ready_w(ready_w),
       .ready_r(ready_r),
       .ad_i_r(ad_i_r),
       .clk_w(clk_w),
       .ads_w(ads_w),
       .ad_o_w(ad_o_w),
       .lw_r_w(lw_r_w),
       .blast_w(blast_w),
       .wait_l_w(wait_l_w),
       .time_out_w(time_out_w),
       .clk_r(clk_r),
       .ads_r(ads_r),
       .ad_o_r(ad_o_r),
       .lw_r_r(lw_r_r),
       .blast_r(blast_r),
       .wait_l_r(wait_l_r),
       .time_out_r(time_out_r) 
       );



  ic_tcorearray_wrif  ic_tcorearray_ifw
  (
       .id0(id[0]),
       .id1(id[1]),
       .id2(id[2]),
       .ready(ready_w),
       .clk(clk_w),
       .clrn(clrn),
       .ads(ads_w),
       .ad_i(ad_o_w),
       .lw_r_i(lw_r_w),
       .blast(blast_w),
       .wait_l(wait_l_w),
       .time_out(time_out_w),
       .lw_r(l_wr),
       .addr(addr_wr),
       .ad(l_data_wr),
       .mem_ready(mem_ready_wr),
       //============================================
       //=        Write variable connection         =
       //============================================
       .tc_ctrl(tc_ctrl),
       .mbvec_size(mbvec_size),
       .mbidx_rd_bound(mbidx_rd_bound),
       .ma_rd_bound(ma_rd_bound),
       .buf_ld_sel(buf_ld_sel),
       .sel_start_cross_bar_00_host_rd_00(sel_start_cross_bar_00_host_rd_00),
       .sel_cross_bar_00_host_wr_00(sel_cross_bar_00_host_wr_00),
       .sel_start_cross_bar_00_host_wr_00(sel_start_cross_bar_00_host_wr_00),
       .sel_start_cross_bar_01_host_rd_01(sel_start_cross_bar_01_host_rd_01),
       .sel_cross_bar_01_host_wr_01(sel_cross_bar_01_host_wr_01),
       .sel_start_cross_bar_01_host_wr_01(sel_start_cross_bar_01_host_wr_01),
       .sel_start_cross_bar_02_host_rd_02(sel_start_cross_bar_02_host_rd_02),
       .sel_cross_bar_02_host_wr_02(sel_cross_bar_02_host_wr_02),
       .sel_start_cross_bar_02_host_wr_02(sel_start_cross_bar_02_host_wr_02),
       .sel_start_cross_bar_03_host_rd_03(sel_start_cross_bar_03_host_rd_03),
       .sel_cross_bar_03_host_wr_03(sel_cross_bar_03_host_wr_03),
       .sel_start_cross_bar_03_host_wr_03(sel_start_cross_bar_03_host_wr_03),
       .sel_start_cross_bar_04_host_rd_04(sel_start_cross_bar_04_host_rd_04),
       .sel_cross_bar_04_host_wr_04(sel_cross_bar_04_host_wr_04),
       .sel_start_cross_bar_04_host_wr_04(sel_start_cross_bar_04_host_wr_04),
       .sel_start_cross_bar_05_host_rd_05(sel_start_cross_bar_05_host_rd_05),
       .sel_cross_bar_05_host_wr_05(sel_cross_bar_05_host_wr_05),
       .sel_start_cross_bar_05_host_wr_05(sel_start_cross_bar_05_host_wr_05),
       .sel_start_cross_bar_20_host_rd_20(sel_start_cross_bar_20_host_rd_20),
       .sel_cross_bar_20_host_wr_20(sel_cross_bar_20_host_wr_20),
       .sel_start_cross_bar_20_host_wr_20(sel_start_cross_bar_20_host_wr_20),
       .sel_start_cross_bar_21_host_rd_21(sel_start_cross_bar_21_host_rd_21),
       .sel_cross_bar_21_host_wr_21(sel_cross_bar_21_host_wr_21),
       .sel_start_cross_bar_21_host_wr_21(sel_start_cross_bar_21_host_wr_21) 
       );



  ic_tcorearray_rdif  ic_tcorearray_ifr
  (
       .id0(id[0]),
       .id1(id[1]),
       .id2(id[2]),
       .ready(ready_r),
       .clk(clk_r),
       .clrn(clrn),
       .ad_o(ad_i_r),
       .ads(ads_r),
       .ad_i(ad_o_r),
       .lw_r_i(lw_r_r),
       .blast(blast_r),
       .wait_l(wait_l_r),
       .time_out(time_out_r),
       .lw_r(l_rd),
       .addr(addr_rd),
       .mem_data(l_data_rd),
       .mem_ready(mem_ready_rd),
       .user_flush(user_flush_rd),
       //============================================
       //=         Read variable connection         =
       //============================================
       .lat_counter(lat_counter),
       .err_info(err_info),
       .rbf_version(rbf_version),
       .build_version(build_version),
       .almost_empty_host_rd_00(almost_empty_host_rd_00),
       .almost_full_host_rd_00(almost_full_host_rd_00),
       .almost_full_host_wr_00(almost_full_host_wr_00),
       .almost_empty_host_rd_01(almost_empty_host_rd_01),
       .almost_full_host_rd_01(almost_full_host_rd_01),
       .almost_full_host_wr_01(almost_full_host_wr_01),
       .almost_empty_host_rd_02(almost_empty_host_rd_02),
       .almost_full_host_rd_02(almost_full_host_rd_02),
       .almost_full_host_wr_02(almost_full_host_wr_02),
       .almost_empty_host_rd_03(almost_empty_host_rd_03),
       .almost_full_host_rd_03(almost_full_host_rd_03),
       .almost_full_host_wr_03(almost_full_host_wr_03),
       .almost_empty_host_rd_04(almost_empty_host_rd_04),
       .almost_full_host_rd_04(almost_full_host_rd_04),
       .almost_full_host_wr_04(almost_full_host_wr_04),
       .almost_empty_host_rd_05(almost_empty_host_rd_05),
       .almost_full_host_rd_05(almost_full_host_rd_05),
       .almost_full_host_wr_05(almost_full_host_wr_05),
       .almost_empty_host_rd_20(almost_empty_host_rd_20),
       .almost_full_host_rd_20(almost_full_host_rd_20),
       .almost_full_host_wr_20(almost_full_host_wr_20),
       .almost_empty_host_rd_21(almost_empty_host_rd_21),
       .almost_full_host_rd_21(almost_full_host_rd_21),
       .almost_full_host_wr_21(almost_full_host_wr_21),
       .sel_cross_bar_00_host_rd_00(sel_cross_bar_00_host_rd_00),
       .sel_cross_bar_01_host_rd_01(sel_cross_bar_01_host_rd_01),
       .sel_cross_bar_02_host_rd_02(sel_cross_bar_02_host_rd_02),
       .sel_cross_bar_03_host_rd_03(sel_cross_bar_03_host_rd_03),
       .sel_cross_bar_04_host_rd_04(sel_cross_bar_04_host_rd_04),
       .sel_cross_bar_05_host_rd_05(sel_cross_bar_05_host_rd_05),
       .sel_cross_bar_20_host_rd_20(sel_cross_bar_20_host_rd_20),
       .sel_cross_bar_21_host_rd_21(sel_cross_bar_21_host_rd_21) 
       );



endmodule
