//**************************************************************************************************************************************************************
//  Gidel Copyright (C) 1993-2025                                                                                                                             
//  HDL ic_tcorearray_rdif was generated by Gidel ProcWizard Application version 9.8.7.3                                                                      
//  ic_tcorearray_rdif is the bus interface for ****  device (IC) 1 ****                                                                                      
//  This file was generated for PROC configuration file  :"C:\Users\tianchu.ji\Documents\block_sparse_test\tensor_core_array_proj_mem.pcaf".                  
//  This file may only be used for initialization and usage of Gidel PROC boards.                                                                             
//  Using this file, or any other related files, for any other purpose, is prohibited .                                                                       
//  No other licenses are provided herein.                                                                                                                    
//  Created  Fri Mar 21 17:56:29 2025                                                                                                                         
//*************************************************************************************************************************************************************
     module  ic_tcorearray_rdif
     (
          //============================================
          //=          Local bus connections           =
          //============================================
          input wire               clk,           // local bus clock
          input wire               clrn,          // Global reset signal. Active low
          output wire              blast_o,
          input wire               blast,
          input wire               ads,
          input wire               lw_r_i,
          output wire              lw_r,
          input wire               wait_l,
          input wire               time_out,
          output wire              bterm,
          output wire              ready,
          output reg      [31:0]   addr,          // local bus address
          input wire      [255:0]  ad_i,
          output wire     [255:0]  ad_o,
          output wire     [255:0]  ad,
          input wire      [255:0]  mem_data,
          //============================================
          //=       feedback from user memories        =
          //============================================
          input wire               mem_ready,     // assert this signal high when memory data is valid
          input wire               user_flush,
          //============================================
          //=  Output from the logic to the host (status registers)  =
          //============================================
          input wire      [31:0]   lat_counter,
          input wire      [31:0]   err_info,
          // version of RBF
          input wire      [7:0]    rbf_version,   // RBF_Info[7:0]
          input wire      [7:0]    build_version, // RBF_Info[15:8]
          input wire               almost_empty_host_rd_00, // status_host_rd_00[0]
          input wire               almost_full_host_rd_00, // status_host_rd_00[1]
          input wire               almost_full_host_wr_00, // status_host_wr_00[1]
          input wire               almost_empty_host_rd_01, // status_host_rd_01[0]
          input wire               almost_full_host_rd_01, // status_host_rd_01[1]
          input wire               almost_full_host_wr_01, // status_host_wr_01[1]
          input wire               almost_empty_host_rd_02, // status_host_rd_02[0]
          input wire               almost_full_host_rd_02, // status_host_rd_02[1]
          input wire               almost_full_host_wr_02, // status_host_wr_02[1]
          input wire               almost_empty_host_rd_03, // status_host_rd_03[0]
          input wire               almost_full_host_rd_03, // status_host_rd_03[1]
          input wire               almost_full_host_wr_03, // status_host_wr_03[1]
          input wire               almost_empty_host_rd_04, // status_host_rd_04[0]
          input wire               almost_full_host_rd_04, // status_host_rd_04[1]
          input wire               almost_full_host_wr_04, // status_host_wr_04[1]
          input wire               almost_empty_host_rd_05, // status_host_rd_05[0]
          input wire               almost_full_host_rd_05, // status_host_rd_05[1]
          input wire               almost_full_host_wr_05, // status_host_wr_05[1]
          input wire               almost_empty_host_rd_20, // status_host_rd_20[0]
          input wire               almost_full_host_rd_20, // status_host_rd_20[1]
          input wire               almost_full_host_wr_20, // status_host_wr_20[1]
          input wire               almost_empty_host_rd_21, // status_host_rd_21[0]
          input wire               almost_full_host_rd_21, // status_host_rd_21[1]
          input wire               almost_full_host_wr_21, // status_host_wr_21[1]
          //============================================
          //=  Input from the host to the logic (mode registers)  =
          //============================================
          input wire               id2,
          input wire               id1,
          input wire               id0,
          //============================================
          //=  Selectors to all memory address spaces  =
          //============================================
          output wire              sel_cross_bar_00_host_rd_00,
          output wire              sel_cross_bar_01_host_rd_01,
          output wire              sel_cross_bar_02_host_rd_02,
          output wire              sel_cross_bar_03_host_rd_03,
          output wire              sel_cross_bar_04_host_rd_04,
          output wire              sel_cross_bar_05_host_rd_05,
          output wire              sel_cross_bar_20_host_rd_20,
          output wire              sel_cross_bar_21_host_rd_21 
     );

      
     //============================================
     //=              WIRES AND REGS              =
     //============================================
     wire                     ad_oe;
     wire                     ready_i;
     reg                 sel_gmode;
     reg                 sel_ic;
     reg                 sel_read_ic;
     wire                     sel_ic_lcell;
     reg    [255:0]      ad_out;
     wire                     sel_ports;
     reg                 sel_ports_d;
     wire                     bus_end;
     //============================================
     //=        Address decoder selectors         =
     //============================================
     reg                 den;
     reg                 sel_lat_counter ;
     reg                 sel_err_info ;
     reg                 sel_RBF_Info ;
     reg                 sel_status_host_rd_00 ;
     reg                 sel_status_host_wr_00 ;
     reg                 sel_status_host_rd_01 ;
     reg                 sel_status_host_wr_01 ;
     reg                 sel_status_host_rd_02 ;
     reg                 sel_status_host_wr_02 ;
     reg                 sel_status_host_rd_03 ;
     reg                 sel_status_host_wr_03 ;
     reg                 sel_status_host_rd_04 ;
     reg                 sel_status_host_wr_04 ;
     reg                 sel_status_host_rd_05 ;
     reg                 sel_status_host_wr_05 ;
     reg                 sel_status_host_rd_20 ;
     reg                 sel_status_host_wr_20 ;
     reg                 sel_status_host_rd_21 ;
     reg                 sel_status_host_wr_21 ;
     reg                 sel_cross_bar_00_host_rd_00_ff;
     reg                 sel_cross_bar_01_host_rd_01_ff;
     reg                 sel_cross_bar_02_host_rd_02_ff;
     reg                 sel_cross_bar_03_host_rd_03_ff;
     reg                 sel_cross_bar_04_host_rd_04_ff;
     reg                 sel_cross_bar_05_host_rd_05_ff;
     reg                 sel_cross_bar_20_host_rd_20_ff;
     reg                 sel_cross_bar_21_host_rd_21_ff;
     wire    [31:0]           zeros;
     //============================================
     //=                  BEGIN                   =
     //============================================
     assign  zeros                        = 32'b0;
       
     always @(posedge clk or negedge clrn)
      if (~clrn) 
         sel_ports_d                     <= 1'b0;
         else
         sel_ports_d                     <= sel_ports;

      
     assign  lw_r                         = lw_r_i;
     assign  ad                           = ad_i;
     assign  ad_o                         = sel_ports ? ad_out: mem_data;
     assign  ad_oe                        = sel_read_ic;
     always @(posedge clk or negedge clrn)
      if (~clrn) 
         ad_out                           <= 256'b0;
      else 
         ad_out[31:0]                     <= 
                                 sel_lat_counter        ? lat_counter[31:0]
                              :  sel_err_info           ? err_info[31:0]
                              :  sel_RBF_Info           ? {zeros[31:16],build_version[7:0],rbf_version[7:0]}
                              :  sel_status_host_rd_00  ? {zeros[31:2],almost_full_host_rd_00,almost_empty_host_rd_00}
                              :  sel_status_host_wr_00  ? {zeros[31:2],almost_full_host_wr_00,zeros[0:0]}
                              :  sel_status_host_rd_01  ? {zeros[31:2],almost_full_host_rd_01,almost_empty_host_rd_01}
                              :  sel_status_host_wr_01  ? {zeros[31:2],almost_full_host_wr_01,zeros[0:0]}
                              :  sel_status_host_rd_02  ? {zeros[31:2],almost_full_host_rd_02,almost_empty_host_rd_02}
                              :  sel_status_host_wr_02  ? {zeros[31:2],almost_full_host_wr_02,zeros[0:0]}
                              :  sel_status_host_rd_03  ? {zeros[31:2],almost_full_host_rd_03,almost_empty_host_rd_03}
                              :  sel_status_host_wr_03  ? {zeros[31:2],almost_full_host_wr_03,zeros[0:0]}
                              :  sel_status_host_rd_04  ? {zeros[31:2],almost_full_host_rd_04,almost_empty_host_rd_04}
                              :  sel_status_host_wr_04  ? {zeros[31:2],almost_full_host_wr_04,zeros[0:0]}
                              :  sel_status_host_rd_05  ? {zeros[31:2],almost_full_host_rd_05,almost_empty_host_rd_05}
                              :  sel_status_host_wr_05  ? {zeros[31:2],almost_full_host_wr_05,zeros[0:0]}
                              :  sel_status_host_rd_20  ? {zeros[31:2],almost_full_host_rd_20,almost_empty_host_rd_20}
                              :  sel_status_host_wr_20  ? {zeros[31:2],almost_full_host_wr_20,zeros[0:0]}
                              :  sel_status_host_rd_21  ? {zeros[31:2],almost_full_host_rd_21,almost_empty_host_rd_21}
                              :  sel_status_host_wr_21  ? {zeros[31:2],almost_full_host_wr_21,zeros[0:0]} : 32'h0BAD;
      
     assign  bus_end                      = wait_l & !ready_i & !den & (!blast) | ads & den;
     assign  ready                        = ready_i;
     assign  bterm                        = 1'b1;
     assign  sel_ic_lcell                 = sel_ic;
     assign  sel_ports                    = sel_gmode;
     always @(posedge clk or negedge clrn)
       if (~clrn) 
         den                      <= 1'b0;
      else     
        if (bus_end)
         den                      <= 1'b1;
        else     
         if  (!ads) 
         den                      <= 1'b0;

     assign  sel_cross_bar_00_host_rd_00  = sel_cross_bar_00_host_rd_00_ff & wait_l;
     assign  sel_cross_bar_01_host_rd_01  = sel_cross_bar_01_host_rd_01_ff & wait_l;
     assign  sel_cross_bar_02_host_rd_02  = sel_cross_bar_02_host_rd_02_ff & wait_l;
     assign  sel_cross_bar_03_host_rd_03  = sel_cross_bar_03_host_rd_03_ff & wait_l;
     assign  sel_cross_bar_04_host_rd_04  = sel_cross_bar_04_host_rd_04_ff & wait_l;
     assign  sel_cross_bar_05_host_rd_05  = sel_cross_bar_05_host_rd_05_ff & wait_l;
     assign  sel_cross_bar_20_host_rd_20  = sel_cross_bar_20_host_rd_20_ff & wait_l;
     assign  sel_cross_bar_21_host_rd_21  = sel_cross_bar_21_host_rd_21_ff & wait_l;
       
     always @(posedge clk or negedge clrn)
      if (~clrn) 
         addr                     <= 32'b0;
     else
        if (!ads| wait_l & !ready_i & !den)
          if (!ads)
               addr                 <= ad[31:0];
           else 
               addr              <= (addr +  32'd32);
     //============================================
     //=  Selectors to all memory address spaces  =
     //============================================
       
       
      
     assign  ready_i                      = !sel_ic_lcell | !sel_ports_d & sel_read_ic & sel_ports | 
               (
                 sel_cross_bar_00_host_rd_00_ff
               | sel_cross_bar_01_host_rd_01_ff
               | sel_cross_bar_02_host_rd_02_ff
               | sel_cross_bar_03_host_rd_03_ff
               | sel_cross_bar_04_host_rd_04_ff
               | sel_cross_bar_05_host_rd_05_ff
               | sel_cross_bar_20_host_rd_20_ff
               | sel_cross_bar_21_host_rd_21_ff
               )  & !mem_ready  & !time_out;
       
      
     

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_ic                   <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}))
         sel_ic                   <= 1'b1;
        else     
         if  (bus_end) 
         sel_ic                   <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_read_ic              <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}))
         sel_read_ic              <= !lw_r;
        else     
         if  (bus_end) 
         sel_read_ic              <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_gmode                <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_gmode                <= 1'b1;
        else     
         if  (bus_end) 
         sel_gmode                <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_lat_counter          <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_lat_counter          <= (ad[10:4] ==  7'h7);
        else     
         if  (bus_end) 
         sel_lat_counter          <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_err_info             <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_err_info             <= (ad[10:4] ==  7'h51);
        else     
         if  (bus_end) 
         sel_err_info             <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_RBF_Info             <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_RBF_Info             <= (ad[10:4] ==  7'h0);
        else     
         if  (bus_end) 
         sel_RBF_Info             <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_00    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_00    <= (ad[10:4] ==  7'h43);
        else     
         if  (bus_end) 
         sel_status_host_rd_00    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_00    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_00    <= (ad[10:4] ==  7'h44);
        else     
         if  (bus_end) 
         sel_status_host_wr_00    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_01    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_01    <= (ad[10:4] ==  7'h45);
        else     
         if  (bus_end) 
         sel_status_host_rd_01    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_01    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_01    <= (ad[10:4] ==  7'h46);
        else     
         if  (bus_end) 
         sel_status_host_wr_01    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_02    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_02    <= (ad[10:4] ==  7'h4F);
        else     
         if  (bus_end) 
         sel_status_host_rd_02    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_02    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_02    <= (ad[10:4] ==  7'h50);
        else     
         if  (bus_end) 
         sel_status_host_wr_02    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_03    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_03    <= (ad[10:4] ==  7'h52);
        else     
         if  (bus_end) 
         sel_status_host_rd_03    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_03    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_03    <= (ad[10:4] ==  7'h53);
        else     
         if  (bus_end) 
         sel_status_host_wr_03    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_04    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_04    <= (ad[10:4] ==  7'h54);
        else     
         if  (bus_end) 
         sel_status_host_rd_04    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_04    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_04    <= (ad[10:4] ==  7'h55);
        else     
         if  (bus_end) 
         sel_status_host_wr_04    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_05    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_05    <= (ad[10:4] ==  7'h56);
        else     
         if  (bus_end) 
         sel_status_host_rd_05    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_05    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_05    <= (ad[10:4] ==  7'h57);
        else     
         if  (bus_end) 
         sel_status_host_wr_05    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_20    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_20    <= (ad[10:4] ==  7'h47);
        else     
         if  (bus_end) 
         sel_status_host_rd_20    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_20    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_20    <= (ad[10:4] ==  7'h48);
        else     
         if  (bus_end) 
         sel_status_host_wr_20    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_rd_21    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_rd_21    <= (ad[10:4] ==  7'h4D);
        else     
         if  (bus_end) 
         sel_status_host_rd_21    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_status_host_wr_21    <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_status_host_wr_21    <= (ad[10:4] ==  7'h4E);
        else     
         if  (bus_end) 
         sel_status_host_wr_21    <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_00_host_rd_00_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_00_host_rd_00_ff <= (ad[15:5]  == 11'h78)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_00_host_rd_00_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_01_host_rd_01_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_01_host_rd_01_ff <= (ad[15:5]  == 11'h80)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_01_host_rd_01_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_02_host_rd_02_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_02_host_rd_02_ff <= (ad[15:5]  == 11'ha8)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_02_host_rd_02_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_03_host_rd_03_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_03_host_rd_03_ff <= (ad[15:5]  == 11'haf)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_03_host_rd_03_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_04_host_rd_04_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_04_host_rd_04_ff <= (ad[15:5]  == 11'hb3)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_04_host_rd_04_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_05_host_rd_05_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_05_host_rd_05_ff <= (ad[15:5]  == 11'hb7)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_05_host_rd_05_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_20_host_rd_20_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_20_host_rd_20_ff <= (ad[15:5]  == 11'h88)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_20_host_rd_20_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_21_host_rd_21_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_21_host_rd_21_ff <= (ad[15:5]  == 11'ha0)&!lw_r;
        else     
         if  (bus_end | user_flush) 
         sel_cross_bar_21_host_rd_21_ff <= 1'b0;

     

endmodule
