//**************************************************************************************************************************************************************
//  Gidel Copyright (C) 1993-2025                                                                                                                             
//  HDL ic_tcorearray_wrif was generated by Gidel ProcWizard Application version 9.8.7.3                                                                      
//  ic_tcorearray_wrif is the bus interface for ****  device (IC) 1 ****                                                                                      
//  This file was generated for PROC configuration file  :"C:\Users\tianchu.ji\Documents\block_sparse_test\tensor_core_array_proj_mem.pcaf".                  
//  This file may only be used for initialization and usage of Gidel PROC boards.                                                                             
//  Using this file, or any other related files, for any other purpose, is prohibited .                                                                       
//  No other licenses are provided herein.                                                                                                                    
//  Created  Fri Mar 21 17:56:29 2025                                                                                                                         
//*************************************************************************************************************************************************************
     module  ic_tcorearray_wrif
     (
          //============================================
          //=          Local bus connections           =
          //============================================
          input wire               clk,           // local bus clock
          input wire               clrn,          // Global reset signal. Active low
          output wire              blast_o,
          input wire               blast,
          input wire               ads,
          input wire               lw_r_i,
          output wire              lw_r,
          input wire               wait_l,
          input wire               time_out,
          output wire              bterm,
          output wire              ready,
          output reg      [31:0]   addr,          // local bus address
          input wire      [255:0]  ad_i,
          output wire     [255:0]  ad,
          //============================================
          //=       feedback from user memories        =
          //============================================
          input wire               mem_ready,     // assert this signal high when memory data is valid
          //============================================
          //=  Input from the host to the logic (mode registers)  =
          //============================================
          output reg      [7:0]    tc_ctrl,       // ctrl[7:0]
          output reg      [15:0]   mbvec_size,    // ctrl[23:8]
          output reg      [31:0]   mbidx_rd_bound,
          output reg      [31:0]   ma_rd_bound,
          output reg      [31:0]   buf_ld_sel,
          input wire               id2,
          input wire               id1,
          input wire               id0,
          //============================================
          //=  Selectors to all memory address spaces  =
          //============================================
          output wire              sel_start_cross_bar_00_host_rd_00,
          output wire              sel_cross_bar_00_host_wr_00,
          output wire              sel_start_cross_bar_00_host_wr_00,
          output wire              sel_start_cross_bar_01_host_rd_01,
          output wire              sel_cross_bar_01_host_wr_01,
          output wire              sel_start_cross_bar_01_host_wr_01,
          output wire              sel_start_cross_bar_02_host_rd_02,
          output wire              sel_cross_bar_02_host_wr_02,
          output wire              sel_start_cross_bar_02_host_wr_02,
          output wire              sel_start_cross_bar_03_host_rd_03,
          output wire              sel_cross_bar_03_host_wr_03,
          output wire              sel_start_cross_bar_03_host_wr_03,
          output wire              sel_start_cross_bar_04_host_rd_04,
          output wire              sel_cross_bar_04_host_wr_04,
          output wire              sel_start_cross_bar_04_host_wr_04,
          output wire              sel_start_cross_bar_05_host_rd_05,
          output wire              sel_cross_bar_05_host_wr_05,
          output wire              sel_start_cross_bar_05_host_wr_05,
          output wire              sel_start_cross_bar_20_host_rd_20,
          output wire              sel_cross_bar_20_host_wr_20,
          output wire              sel_start_cross_bar_20_host_wr_20,
          output wire              sel_start_cross_bar_21_host_rd_21,
          output wire              sel_cross_bar_21_host_wr_21,
          output wire              sel_start_cross_bar_21_host_wr_21 
     );

      
     //============================================
     //=              WIRES AND REGS              =
     //============================================
     wire                     ad_oe;
     wire                     ready_i;
     reg                 sel_gmode;
     reg                 sel_ic;
     reg                 sel_read_ic;
     wire                     sel_ic_lcell;
     reg    [255:0]      ad_out;
     wire                     sel_ports;
     reg                 sel_ports_d;
     wire                     bus_end;
     //============================================
     //=        Address decoder selectors         =
     //============================================
     reg                 den;
     reg                 sel_ctrl ;
     reg                 sel_mbidx_rd_bound ;
     reg                 sel_ma_rd_bound ;
     reg                 sel_buf_ld_sel ;
     reg                 sel_start_cross_bar_00_host_rd_00_ff;
     reg                 sel_cross_bar_00_host_wr_00_ff;
     reg                 sel_start_cross_bar_00_host_wr_00_ff;
     reg                 sel_start_cross_bar_01_host_rd_01_ff;
     reg                 sel_cross_bar_01_host_wr_01_ff;
     reg                 sel_start_cross_bar_01_host_wr_01_ff;
     reg                 sel_start_cross_bar_02_host_rd_02_ff;
     reg                 sel_cross_bar_02_host_wr_02_ff;
     reg                 sel_start_cross_bar_02_host_wr_02_ff;
     reg                 sel_start_cross_bar_03_host_rd_03_ff;
     reg                 sel_cross_bar_03_host_wr_03_ff;
     reg                 sel_start_cross_bar_03_host_wr_03_ff;
     reg                 sel_start_cross_bar_04_host_rd_04_ff;
     reg                 sel_cross_bar_04_host_wr_04_ff;
     reg                 sel_start_cross_bar_04_host_wr_04_ff;
     reg                 sel_start_cross_bar_05_host_rd_05_ff;
     reg                 sel_cross_bar_05_host_wr_05_ff;
     reg                 sel_start_cross_bar_05_host_wr_05_ff;
     reg                 sel_start_cross_bar_20_host_rd_20_ff;
     reg                 sel_cross_bar_20_host_wr_20_ff;
     reg                 sel_start_cross_bar_20_host_wr_20_ff;
     reg                 sel_start_cross_bar_21_host_rd_21_ff;
     reg                 sel_cross_bar_21_host_wr_21_ff;
     reg                 sel_start_cross_bar_21_host_wr_21_ff;
     //============================================
     //=                  BEGIN                   =
     //============================================
       
     always @(posedge clk or negedge clrn)
      if (~clrn) 
         sel_ports_d                     <= 1'b0;
         else
         sel_ports_d                     <= sel_ports;

      
     assign  lw_r                         = lw_r_i;
     assign  ad                           = ad_i;
     assign  ad_oe                        = sel_read_ic;
     assign  bus_end                      = wait_l & !ready_i & !den & (!blast) | ads & den;
     assign  ready                        = ready_i;
     assign  bterm                        = 1'b1;
     assign  sel_ic_lcell                 = sel_ic;
     assign  sel_ports                    = sel_gmode;
     always @(posedge clk or negedge clrn)
       if (~clrn) 
         den                      <= 1'b0;
      else     
        if (bus_end)
         den                      <= 1'b1;
        else     
         if  (!ads) 
         den                      <= 1'b0;

     assign  sel_start_cross_bar_00_host_rd_00  = sel_start_cross_bar_00_host_rd_00_ff & wait_l;
     assign  sel_cross_bar_00_host_wr_00  = sel_cross_bar_00_host_wr_00_ff & wait_l;
     assign  sel_start_cross_bar_00_host_wr_00  = sel_start_cross_bar_00_host_wr_00_ff & wait_l;
     assign  sel_start_cross_bar_01_host_rd_01  = sel_start_cross_bar_01_host_rd_01_ff & wait_l;
     assign  sel_cross_bar_01_host_wr_01  = sel_cross_bar_01_host_wr_01_ff & wait_l;
     assign  sel_start_cross_bar_01_host_wr_01  = sel_start_cross_bar_01_host_wr_01_ff & wait_l;
     assign  sel_start_cross_bar_02_host_rd_02  = sel_start_cross_bar_02_host_rd_02_ff & wait_l;
     assign  sel_cross_bar_02_host_wr_02  = sel_cross_bar_02_host_wr_02_ff & wait_l;
     assign  sel_start_cross_bar_02_host_wr_02  = sel_start_cross_bar_02_host_wr_02_ff & wait_l;
     assign  sel_start_cross_bar_03_host_rd_03  = sel_start_cross_bar_03_host_rd_03_ff & wait_l;
     assign  sel_cross_bar_03_host_wr_03  = sel_cross_bar_03_host_wr_03_ff & wait_l;
     assign  sel_start_cross_bar_03_host_wr_03  = sel_start_cross_bar_03_host_wr_03_ff & wait_l;
     assign  sel_start_cross_bar_04_host_rd_04  = sel_start_cross_bar_04_host_rd_04_ff & wait_l;
     assign  sel_cross_bar_04_host_wr_04  = sel_cross_bar_04_host_wr_04_ff & wait_l;
     assign  sel_start_cross_bar_04_host_wr_04  = sel_start_cross_bar_04_host_wr_04_ff & wait_l;
     assign  sel_start_cross_bar_05_host_rd_05  = sel_start_cross_bar_05_host_rd_05_ff & wait_l;
     assign  sel_cross_bar_05_host_wr_05  = sel_cross_bar_05_host_wr_05_ff & wait_l;
     assign  sel_start_cross_bar_05_host_wr_05  = sel_start_cross_bar_05_host_wr_05_ff & wait_l;
     assign  sel_start_cross_bar_20_host_rd_20  = sel_start_cross_bar_20_host_rd_20_ff & wait_l;
     assign  sel_cross_bar_20_host_wr_20  = sel_cross_bar_20_host_wr_20_ff & wait_l;
     assign  sel_start_cross_bar_20_host_wr_20  = sel_start_cross_bar_20_host_wr_20_ff & wait_l;
     assign  sel_start_cross_bar_21_host_rd_21  = sel_start_cross_bar_21_host_rd_21_ff & wait_l;
     assign  sel_cross_bar_21_host_wr_21  = sel_cross_bar_21_host_wr_21_ff & wait_l;
     assign  sel_start_cross_bar_21_host_wr_21  = sel_start_cross_bar_21_host_wr_21_ff & wait_l;
       
     always @(posedge clk or negedge clrn)
      if (~clrn) 
         addr                     <= 32'b0;
     else
        if (!ads| wait_l & !ready_i & !den)
          if (!ads)
               addr                 <= ad[31:0];
           else 
               addr              <= (addr +  32'd32);
     //============================================
     //=  Selectors to all memory address spaces  =
     //============================================
     always @(posedge clk or negedge clrn)
       if (~clrn) 
         tc_ctrl                  <= 8'b0;
      else     
        if (sel_ctrl & lw_r)
         tc_ctrl[7:0]                  <= ad[7:0];

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         mbvec_size               <= 16'b0;
      else     
        if (sel_ctrl & lw_r)
         mbvec_size[15:0]               <= ad[23:8];

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         mbidx_rd_bound           <= 32'b0;
      else     
        if (sel_mbidx_rd_bound & lw_r)
         mbidx_rd_bound           <= ad[31:0];

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         ma_rd_bound              <= 32'b0;
      else     
        if (sel_ma_rd_bound & lw_r)
         ma_rd_bound              <= ad[31:0];

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         buf_ld_sel               <= 32'b0;
      else     
        if (sel_buf_ld_sel & lw_r)
         buf_ld_sel               <= ad[31:0];

       
       
      
     assign  ready_i                      = !sel_ic_lcell | !sel_ports_d & sel_read_ic & sel_ports | 
               (
                 sel_start_cross_bar_00_host_rd_00_ff
               | sel_cross_bar_00_host_wr_00_ff
               | sel_start_cross_bar_00_host_wr_00_ff
               | sel_start_cross_bar_01_host_rd_01_ff
               | sel_cross_bar_01_host_wr_01_ff
               | sel_start_cross_bar_01_host_wr_01_ff
               | sel_start_cross_bar_02_host_rd_02_ff
               | sel_cross_bar_02_host_wr_02_ff
               | sel_start_cross_bar_02_host_wr_02_ff
               | sel_start_cross_bar_03_host_rd_03_ff
               | sel_cross_bar_03_host_wr_03_ff
               | sel_start_cross_bar_03_host_wr_03_ff
               | sel_start_cross_bar_04_host_rd_04_ff
               | sel_cross_bar_04_host_wr_04_ff
               | sel_start_cross_bar_04_host_wr_04_ff
               | sel_start_cross_bar_05_host_rd_05_ff
               | sel_cross_bar_05_host_wr_05_ff
               | sel_start_cross_bar_05_host_wr_05_ff
               | sel_start_cross_bar_20_host_rd_20_ff
               | sel_cross_bar_20_host_wr_20_ff
               | sel_start_cross_bar_20_host_wr_20_ff
               | sel_start_cross_bar_21_host_rd_21_ff
               | sel_cross_bar_21_host_wr_21_ff
               | sel_start_cross_bar_21_host_wr_21_ff
               )  & !mem_ready  & !time_out;
       
      
     

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_ic                   <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}))
         sel_ic                   <= 1'b1;
        else     
         if  (bus_end) 
         sel_ic                   <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_read_ic              <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}))
         sel_read_ic              <= !lw_r;
        else     
         if  (bus_end) 
         sel_read_ic              <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_gmode                <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_gmode                <= 1'b1;
        else     
         if  (bus_end) 
         sel_gmode                <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_ctrl                 <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_ctrl                 <= (ad[10:4] ==  7'h1);
        else     
         if  (bus_end) 
         sel_ctrl                 <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_mbidx_rd_bound       <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_mbidx_rd_bound       <= (ad[10:4] ==  7'h4);
        else     
         if  (bus_end) 
         sel_mbidx_rd_bound       <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_ma_rd_bound          <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_ma_rd_bound          <= (ad[10:4] ==  7'h5);
        else     
         if  (bus_end) 
         sel_ma_rd_bound          <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_buf_ld_sel           <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20:19] == 2'h0))
         sel_buf_ld_sel           <= (ad[10:4] ==  7'h6);
        else     
         if  (bus_end) 
         sel_buf_ld_sel           <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_00_host_rd_00_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_00_host_rd_00_ff <= (ad[15:4]  == 12'hf4)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_00_host_rd_00_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_00_host_wr_00_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_00_host_wr_00_ff <= (ad[15:5]  == 11'h7c)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_00_host_wr_00_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_00_host_wr_00_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_00_host_wr_00_ff <= (ad[15:4]  == 12'hfc)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_00_host_wr_00_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_01_host_rd_01_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_01_host_rd_01_ff <= (ad[15:4]  == 12'h104)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_01_host_rd_01_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_01_host_wr_01_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_01_host_wr_01_ff <= (ad[15:5]  == 11'h84)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_01_host_wr_01_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_01_host_wr_01_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_01_host_wr_01_ff <= (ad[15:4]  == 12'h10c)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_01_host_wr_01_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_02_host_rd_02_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_02_host_rd_02_ff <= (ad[15:4]  == 12'h154)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_02_host_rd_02_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_02_host_wr_02_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_02_host_wr_02_ff <= (ad[15:5]  == 11'hac)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_02_host_wr_02_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_02_host_wr_02_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_02_host_wr_02_ff <= (ad[15:4]  == 12'h15c)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_02_host_wr_02_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_03_host_rd_03_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_03_host_rd_03_ff <= (ad[15:4]  == 12'h160)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_03_host_rd_03_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_03_host_wr_03_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_03_host_wr_03_ff <= (ad[15:5]  == 11'hb1)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_03_host_wr_03_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_03_host_wr_03_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_03_host_wr_03_ff <= (ad[15:4]  == 12'h164)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_03_host_wr_03_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_04_host_rd_04_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_04_host_rd_04_ff <= (ad[15:4]  == 12'h168)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_04_host_rd_04_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_04_host_wr_04_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_04_host_wr_04_ff <= (ad[15:5]  == 11'hb5)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_04_host_wr_04_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_04_host_wr_04_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_04_host_wr_04_ff <= (ad[15:4]  == 12'h16c)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_04_host_wr_04_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_05_host_rd_05_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_05_host_rd_05_ff <= (ad[15:4]  == 12'h170)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_05_host_rd_05_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_05_host_wr_05_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_05_host_wr_05_ff <= (ad[15:5]  == 11'hb9)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_05_host_wr_05_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_05_host_wr_05_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_05_host_wr_05_ff <= (ad[15:4]  == 12'h174)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_05_host_wr_05_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_20_host_rd_20_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_20_host_rd_20_ff <= (ad[15:4]  == 12'h114)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_20_host_rd_20_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_20_host_wr_20_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_20_host_wr_20_ff <= (ad[15:5]  == 11'h8c)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_20_host_wr_20_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_20_host_wr_20_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_20_host_wr_20_ff <= (ad[15:4]  == 12'h11c)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_20_host_wr_20_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_21_host_rd_21_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_21_host_rd_21_ff <= (ad[15:4]  == 12'h144)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_21_host_rd_21_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_cross_bar_21_host_wr_21_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_cross_bar_21_host_wr_21_ff <= (ad[15:5]  == 11'ha4)&lw_r;
        else     
         if  (bus_end) 
         sel_cross_bar_21_host_wr_21_ff <= 1'b0;

     always @(posedge clk or negedge clrn)
       if (~clrn) 
         sel_start_cross_bar_21_host_wr_21_ff <= 1'b0;
      else     
        if ((!ads& !ad[31]) & (ad[24:24] ==  1'b0) & (ad[23:21] == {id2,id1,id0}) & (ad[20]))
         sel_start_cross_bar_21_host_wr_21_ff <= (ad[15:4]  == 12'h14c)&lw_r;
        else     
         if  (bus_end) 
         sel_start_cross_bar_21_host_wr_21_ff <= 1'b0;

     

endmodule
